/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.consumer.events;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.kafka.consumer.events.EventsProto;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsMapper {
    private static final Logger LOG = LoggerFactory.getLogger(EventsMapper.class);

    public static Event toEvent(EventsProto.Event pbEvent) {
        if (Strings.isNullOrEmpty((String)pbEvent.getUei())) {
            LOG.warn("Event will not be forwarded, `uei` is required field, skipped Event : \n {}", (Object)pbEvent);
            return null;
        }
        if (Strings.isNullOrEmpty((String)pbEvent.getSource())) {
            LOG.warn("Event will not be forwarded, `source` is required field, skipped Event : \n {}", (Object)pbEvent);
            return null;
        }
        EventBuilder builder = new EventBuilder(pbEvent.getUei(), pbEvent.getSource());
        builder.setSeverity(OnmsSeverity.get((String)pbEvent.getSeverity().name()).getLabel());
        EventsMapper.getString(pbEvent.getHost()).ifPresent(arg_0 -> ((EventBuilder)builder).setHost(arg_0));
        if (pbEvent.getNodeId() > 0) {
            builder.setNodeid((long)pbEvent.getNodeId());
        }
        EventsMapper.getString(pbEvent.getIpAddress()).ifPresent(ip -> builder.setInterface(InetAddressUtils.getInetAddress((String)ip)));
        EventsMapper.getString(pbEvent.getServiceName()).ifPresent(arg_0 -> ((EventBuilder)builder).setService(arg_0));
        if (pbEvent.getIfIndex() > 0) {
            builder.setIfIndex(pbEvent.getIfIndex());
        }
        EventsMapper.getString(pbEvent.getDistPoller()).ifPresent(arg_0 -> ((EventBuilder)builder).setDistPoller(arg_0));
        EventsMapper.getString(pbEvent.getDescription()).ifPresent(arg_0 -> ((EventBuilder)builder).setDescription(arg_0));
        EventsMapper.getString(pbEvent.getLogDest()).ifPresent(arg_0 -> ((EventBuilder)builder).setLogDest(arg_0));
        EventsMapper.getString(pbEvent.getLogContent()).ifPresent(arg_0 -> ((EventBuilder)builder).setLogMessage(arg_0));
        for (EventsProto.EventParameter p : pbEvent.getParameterList()) {
            builder.setParam(p.getName(), p.getValue());
        }
        return builder.getEvent();
    }

    public static List<Event> mapProtobufToEvents(List<EventsProto.Event> pbEvents) {
        return pbEvents.stream().map(EventsMapper::toEvent).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Optional<String> getString(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

