/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.adapter;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.processing.Pipeline;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.common.utils.BsonUtils;
import org.opennms.netmgt.telemetry.protocols.flows.AbstractFlowAdapter;
import org.opennms.netmgt.telemetry.protocols.sflow.adapter.SFlow;

public class SFlowAdapter
extends AbstractFlowAdapter<BsonDocument> {
    public SFlowAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry, Pipeline pipeline) {
        super(adapterConfig, metricRegistry, pipeline);
    }

    protected BsonDocument parse(TelemetryMessageLogEntry message) {
        return new RawBsonDocument(message.getByteArray());
    }

    private static RuntimeException invalidDocument() {
        throw new RuntimeException("Invalid Document");
    }

    public List<Flow> convert(BsonDocument packet, Instant receivedAt) {
        return SFlowAdapter.convertDocument(packet, receivedAt);
    }

    public static List<Flow> convertDocument(BsonDocument packet, Instant receivedAt) {
        LinkedList result = Lists.newLinkedList();
        SFlow.Header header = new SFlow.Header(packet);
        for (BsonValue sample : (Iterable)BsonUtils.getArray((BsonDocument)packet, (String[])new String[]{"data", "samples"}).orElseThrow(SFlowAdapter::invalidDocument)) {
            BsonDocument sampleDocument = sample.asDocument();
            String format = (String)BsonUtils.getString((BsonDocument)sampleDocument, (String[])new String[]{"format"}).orElseThrow(SFlowAdapter::invalidDocument);
            if (!"0:1".equals(format) && !"0:3".equals(format) || !BsonUtils.first((Optional[])new Optional[]{BsonUtils.get((BsonDocument)sampleDocument, (String[])new String[]{"data", "flows", "0:1", "ipv4"}), BsonUtils.get((BsonDocument)sampleDocument, (String[])new String[]{"data", "flows", "0:1", "ipv6"}), BsonUtils.get((BsonDocument)sampleDocument, (String[])new String[]{"data", "flows", "0:3"}), BsonUtils.get((BsonDocument)sampleDocument, (String[])new String[]{"data", "flows", "0:4"})}).isPresent()) continue;
            result.add(new SFlow(header, (BsonDocument)BsonUtils.getDocument((BsonDocument)sampleDocument, (String[])new String[]{"data"}).orElseThrow(SFlowAdapter::invalidDocument), receivedAt));
        }
        return result;
    }
}

