/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.snmp.LldpSnmpUtils;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTetraLldpRemTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(TimeTetraLldpRemTableTracker.class);
    public static final SnmpObjId TIMETETRA_LLDP_REM_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.4.1.6527.3.1.2.59.4.1.1");
    public static final String TIMETETRA_LLDP_REM_CHASSIS_ID_SUBTYPE = "tmnxLldpRemChassisIdSubtype";
    public static final String TIMETETRA_LLDP_REM_CHASSIS_ID = "tmnxLldpRemChassisId";
    public static final String TIMETETRA_LLDP_REM_PORT_ID_SUBTYPE = "tmnxLldpRemPortIdSubtype";
    public static final String TIMETETRA_LLDP_REM_PORT_ID = "tmnxLldpRemPortId";
    public static final String TIMETETRA_LLDP_REM_PORT_DESCR = "tmnxLldpRemPortDesc";
    public static final String TIMETETRA_LLDP_REM_SYSNAME = "tmnxLldpRemSysName";
    public static final SnmpObjId TIMETETRA_LLDP_REM_CHASSIS_ID_SUBTYPE_OID = SnmpObjId.get((SnmpObjId)TIMETETRA_LLDP_REM_TABLE_ENTRY, (String)"4");
    public static final SnmpObjId TIMETETRA_LLDP_REM_CHASSIS_ID_OID = SnmpObjId.get((SnmpObjId)TIMETETRA_LLDP_REM_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId TIMETETRA_LLDP_REM_PORT_ID_SUBTYPE_OID = SnmpObjId.get((SnmpObjId)TIMETETRA_LLDP_REM_TABLE_ENTRY, (String)"6");
    public static final SnmpObjId TIMETETRA_LLDP_REM_PORT_ID_OID = SnmpObjId.get((SnmpObjId)TIMETETRA_LLDP_REM_TABLE_ENTRY, (String)"7");
    public static final SnmpObjId TIMETETRA_LLDP_REM_PORT_DESCR_OID = SnmpObjId.get((SnmpObjId)TIMETETRA_LLDP_REM_TABLE_ENTRY, (String)"8");
    public static final SnmpObjId TIMETETRA_LLDP_REM_SYSNAME_OID = SnmpObjId.get((SnmpObjId)TIMETETRA_LLDP_REM_TABLE_ENTRY, (String)"9");
    public static final SnmpObjId[] s_timetetralldpremtable_elemList = new SnmpObjId[]{TIMETETRA_LLDP_REM_CHASSIS_ID_SUBTYPE_OID, TIMETETRA_LLDP_REM_CHASSIS_ID_OID, TIMETETRA_LLDP_REM_PORT_ID_SUBTYPE_OID, TIMETETRA_LLDP_REM_PORT_ID_OID, TIMETETRA_LLDP_REM_PORT_DESCR_OID, TIMETETRA_LLDP_REM_SYSNAME_OID};

    public TimeTetraLldpRemTableTracker() {
        super(s_timetetralldpremtable_elemList);
    }

    public TimeTetraLldpRemTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_timetetralldpremtable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new TimeTetraLldpRemRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processLldpRemRow((TimeTetraLldpRemRow)row);
    }

    public void processLldpRemRow(TimeTetraLldpRemRow row) {
        System.out.printf("\t\t%s (%s)= %s (%s)\n", TIMETETRA_LLDP_REM_CHASSIS_ID_SUBTYPE_OID + "." + row.getInstance().toString(), TIMETETRA_LLDP_REM_CHASSIS_ID_SUBTYPE, row.getLldpRemChassisidSubtype(), LldpUtils.LldpChassisIdSubType.getTypeString((Integer)row.getLldpRemChassisidSubtype()));
        System.out.printf("\t\t%s (%s)= %s \n", TIMETETRA_LLDP_REM_CHASSIS_ID_OID + "." + row.getInstance().toString(), TIMETETRA_LLDP_REM_CHASSIS_ID, LldpSnmpUtils.decodeLldpChassisId(LldpUtils.LldpChassisIdSubType.get((Integer)row.getLldpRemChassisidSubtype()), row.getLldpRemChassisId()));
        System.out.printf("\t\t%s (%s)= %s (%s)\n", TIMETETRA_LLDP_REM_PORT_ID_SUBTYPE_OID + "." + row.getInstance().toString(), TIMETETRA_LLDP_REM_PORT_ID_SUBTYPE, row.getLldpRemPortidSubtype(), LldpUtils.LldpPortIdSubType.getTypeString((Integer)row.getLldpRemPortidSubtype()));
        System.out.printf("\t\t%s (%s)= %s \n", TIMETETRA_LLDP_REM_PORT_ID_OID + "." + row.getInstance().toString(), TIMETETRA_LLDP_REM_PORT_ID, row.getLldpRemPortid());
        System.out.printf("\t\t%s (%s)= %s \n", TIMETETRA_LLDP_REM_PORT_DESCR_OID + "." + row.getInstance().toString(), TIMETETRA_LLDP_REM_PORT_DESCR, row.getLldpRemPortDescr());
        System.out.printf("\t\t%s (%s)= %s \n", TIMETETRA_LLDP_REM_SYSNAME_OID + "." + row.getInstance().toString(), TIMETETRA_LLDP_REM_SYSNAME, row.getLldpRemSysname());
    }

    public static class TimeTetraLldpRemRow
    extends SnmpRowResult {
        public TimeTetraLldpRemRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getLldpLocalPortNum() {
            return this.getInstance().toString().hashCode();
        }

        public Integer getLldpRemIndex() {
            return this.getInstance().getSubIdAt(3);
        }

        public Integer getTmnxLldpRemLocalDestMACAddress() {
            return this.getInstance().getSubIdAt(2);
        }

        public Integer getIfindex() {
            return this.getInstance().getSubIdAt(1);
        }

        public Integer getLldpRemChassisidSubtype() {
            return this.getValue(TIMETETRA_LLDP_REM_CHASSIS_ID_SUBTYPE_OID).toInt();
        }

        public SnmpValue getLldpRemChassisId() {
            return this.getValue(TIMETETRA_LLDP_REM_CHASSIS_ID_OID);
        }

        public Integer getLldpRemPortidSubtype() {
            return this.getValue(TIMETETRA_LLDP_REM_PORT_ID_SUBTYPE_OID).toInt();
        }

        public String getLldpRemPortid() {
            return LldpSnmpUtils.decodeLldpPortId(LldpUtils.LldpPortIdSubType.get((Integer)this.getLldpRemPortidSubtype()), this.getValue(TIMETETRA_LLDP_REM_PORT_ID_OID));
        }

        public String getLldpRemPortDescr() {
            if (this.getValue(TIMETETRA_LLDP_REM_PORT_DESCR_OID) != null) {
                return this.getValue(TIMETETRA_LLDP_REM_PORT_DESCR_OID).toDisplayString();
            }
            return "";
        }

        public String getLldpRemSysname() {
            return this.getValue(TIMETETRA_LLDP_REM_SYSNAME_OID).toDisplayString();
        }

        public LldpLink getLldpLink() {
            LldpLink lldpLink = new LldpLink();
            lldpLink.setLldpRemLocalPortNum(Integer.valueOf(this.getIfindex() * 31 + this.getTmnxLldpRemLocalDestMACAddress()));
            lldpLink.setLldpRemIndex(this.getLldpRemIndex());
            lldpLink.setLldpPortIfindex(this.getIfindex());
            lldpLink.setLldpRemChassisIdSubType(LldpUtils.LldpChassisIdSubType.get((Integer)this.getLldpRemChassisidSubtype()));
            lldpLink.setLldpRemChassisId(LldpSnmpUtils.decodeLldpChassisId(lldpLink.getLldpRemChassisIdSubType(), this.getLldpRemChassisId()));
            lldpLink.setLldpRemSysname(this.getLldpRemSysname());
            lldpLink.setLldpRemPortId(this.getLldpRemPortid());
            lldpLink.setLldpRemPortIdSubType(LldpUtils.LldpPortIdSubType.get((Integer)this.getLldpRemPortidSubtype()));
            lldpLink.setLldpRemPortDescr(this.getLldpRemPortDescr());
            LOG.debug("getLldpLink: Rem Index: {}, ifindex: {}, TmnxLldpRemLocalDestMACAddress: {}, identifier: {}, chassis subtype: {}, \n rem sysname: {}, rem port: {}, rem port subtype: {}", new Object[]{lldpLink.getLldpRemIndex(), lldpLink.getLldpPortIfindex(), this.getTmnxLldpRemLocalDestMACAddress(), lldpLink.getLldpRemChassisId(), LldpUtils.LldpChassisIdSubType.getTypeString((Integer)this.getLldpRemChassisidSubtype()), lldpLink.getLldpRemSysname(), lldpLink.getLldpRemPortId(), LldpUtils.LldpPortIdSubType.getTypeString((Integer)this.getLldpRemPortidSubtype())});
            return lldpLink;
        }
    }
}

