/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.command.support;

import org.apache.karaf.scheduler.Scheduler;
import org.apache.karaf.scheduler.SchedulerError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerJob
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerJob.class);
    private final Scheduler scheduler;
    private final String name;

    public TriggerJob(Scheduler scheduler, String name) {
        this.scheduler = scheduler;
        this.name = name;
    }

    @Override
    public void run() {
        try {
            if (!this.scheduler.trigger(this.name)) {
                LOGGER.warn("Could not find a scheduled job with name " + this.name);
            }
        }
        catch (SchedulerError ex) {
            LOGGER.error("Failed to trigger job {}", (Object)this.name, (Object)ex);
        }
    }
}

