/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.command.support;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.apache.karaf.scheduler.Job;
import org.apache.karaf.scheduler.JobContext;
import org.apache.karaf.shell.api.console.Function;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptJob.class);
    private final SessionFactory sessionFactory;
    private final Session session;
    private final Function script;

    public ScriptJob(SessionFactory sessionFactory, Session session, Function script) {
        this.sessionFactory = sessionFactory;
        this.session = session;
        this.script = script;
    }

    @Override
    public void execute(JobContext context) {
        try (Session s = this.sessionFactory.create((InputStream)new ByteArrayInputStream(new byte[0]), this.session.getConsole(), this.session.getConsole(), this.session);){
            this.script.execute(s, Collections.singletonList(context));
        }
        catch (Exception e) {
            LOGGER.warn("Error executing script", (Throwable)e);
        }
    }
}

