/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.commands;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpProfileMapper;
import org.opennms.netmgt.snmp.commands.ShowConfigCommand;

@Command(scope="opennms", name="snmp-fit", description="Fit a profile for a given IP address")
@Service
public class FitProfileCommand
implements Action {
    @Reference
    private SnmpProfileMapper snmpProfileMapper;
    @Reference
    private SnmpAgentConfigFactory agentConfigFactory;
    @Reference
    private EventForwarder eventForwarder;
    @Option(name="-l", aliases={"--location"}, description="Location of IP address that needs fitting")
    String location;
    @Option(name="-s", aliases={"--save"}, description="Save the resulting definition")
    boolean save = false;
    @Option(name="-o", aliases={"--oid"}, description="Custom OID used to fit profile")
    String oid;
    @Option(name="-n", aliases={"--new-suspect"}, description="Send newSuspect event on successful fit")
    boolean sendNewSuspect;
    @Option(name="-f", aliases={"--foreign-source"}, description="Foreign-source name for newSuspect event, if enabled")
    String foreignSource;
    @Argument(name="host", description="IP address to fit", required=true)
    String ipAddress;
    @Argument(index=1, name="label", description="Label of the Snmp Profile used to fit")
    String label;

    public Object execute() {
        CompletableFuture future;
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(this.ipAddress);
            future = this.snmpProfileMapper.fitProfile(this.label, inetAddress, this.location, this.oid);
        }
        catch (UnknownHostException e) {
            System.err.printf("Unknown host '%s' at location '%s': %s%n", this.ipAddress, this.location, e.getMessage());
            return null;
        }
        while (future != null) {
            try {
                Optional agentConfig = (Optional)future.get(1L, TimeUnit.SECONDS);
                if (agentConfig.isPresent()) {
                    System.out.printf("Fitted IP address '%s' with profile '%s', agent config: %n", this.ipAddress, ((SnmpAgentConfig)agentConfig.get()).getProfileLabel());
                    ShowConfigCommand.prettyPrint((SnmpAgentConfig)agentConfig.get());
                    if (this.save) {
                        this.agentConfigFactory.saveAgentConfigAsDefinition((SnmpAgentConfig)agentConfig.get(), this.location, "karaf-shell");
                        System.out.println("*** Saved above config in definitions ***");
                    }
                    if (!this.sendNewSuspect) break;
                    EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "KarafShell_snmp-fit").setInterface(inetAddress);
                    if (!Strings.isNullOrEmpty((String)this.foreignSource)) {
                        eventBuilder.addParam("foreignSource", this.foreignSource);
                    }
                    if (!Strings.isNullOrEmpty((String)this.location)) {
                        eventBuilder.addParam("location", this.location);
                    }
                    this.eventForwarder.sendNow(eventBuilder.getEvent());
                    System.out.printf("Sent newSuspect event for %s, location '%s', foreign-source '%s'%n", this.ipAddress, this.location, this.foreignSource);
                    break;
                }
                if (Strings.isNullOrEmpty((String)this.label)) {
                    System.out.printf("%nDidn't find any matching profile for IP address '%s' %n", this.ipAddress);
                    break;
                }
                System.out.printf("%nProfile with label '%s' didn't fit for IP address '%s'%n", this.label, this.ipAddress);
                break;
            }
            catch (TimeoutException e) {
                System.out.print(".");
            }
            catch (InterruptedException | ExecutionException e1) {
                System.err.printf("\n %s: %s%n", this.ipAddress, e1.getMessage());
                break;
            }
        }
        return null;
    }
}

