/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.snmp.SnmpConfig;

@Command(scope="opennms", name="snmp-config-decrypt", description="Decrypts snmp config and saves it on file system as a separate file")
@Service
public class DecryptSnmpConfigCommand
implements Action {
    @Reference
    SnmpAgentConfigFactory snmpAgentConfigFactory;
    @Option(name="-f", aliases={"--filename"}, description="File name where decrypted SNMP")
    String fileName = "snmp-config-decrypt.xml";

    public Object execute() throws Exception {
        boolean encryptionEnabled = Boolean.getBoolean("org.opennms.snmp.encryption.enabled");
        if (!encryptionEnabled) {
            System.out.println("Encryption is not enabled, \n Set system property `org.opennms.snmp.encryption.enabled` to true to enable encryption on Snmp.");
            return null;
        }
        if (ConfigFileConstants.getFileName((int)ConfigFileConstants.SNMP_CONF_FILE_NAME).equals(this.fileName)) {
            System.out.println("Can't decrypt to original file");
            return null;
        }
        File file = new File(ConfigFileConstants.getHome(), "etc" + File.separator + this.fileName);
        SnmpConfig snmpConfig = this.snmpAgentConfigFactory.getSnmpConfig();
        try (StringWriter writer = new StringWriter();){
            JaxbUtils.marshal((Object)snmpConfig, (Writer)writer);
            String marshalledConfig = writer.toString();
            FileOutputStream out = new FileOutputStream(file);
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            fileWriter.write(marshalledConfig);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            System.out.printf("Exception while writing to decrypted file %s , error : %s", this.fileName, e.getMessage());
        }
        System.out.printf("Decrypted snmp config to file %s", this.fileName);
        return null;
    }
}

