/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.util.Map;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class TextSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(TextSystemReportFormatter.class);

    @Override
    public String getName() {
        return "text";
    }

    @Override
    public String getDescription() {
        return "Simple human-readable indented text";
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public String getExtension() {
        return "txt";
    }

    @Override
    public boolean canStdout() {
        return true;
    }

    @Override
    public void write(SystemReportPlugin plugin) {
        if (plugin.getFullOutputOnly()) {
            return;
        }
        LOG.debug("write({})", (Object)plugin.getName());
        try {
            String title = plugin.getName() + " (" + plugin.getDescription() + "):\n";
            this.getOutputStream().write(title.getBytes());
            for (Map.Entry<String, Resource> entry : plugin.getEntries().entrySet()) {
                Resource value = entry.getValue();
                String text = "\t" + entry.getKey() + ": " + this.getResourceText(value) + "\n";
                this.getOutputStream().write(text.getBytes());
            }
        }
        catch (Throwable e) {
            LOG.error("Error writing plugin data.", e);
        }
    }
}

