/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import org.opennms.netmgt.enlinkd.model.OspfArea;
import org.opennms.netmgt.model.ReadOnlyEntity;

@ReadOnlyEntity
public class OspfAreaTopologyEntity {
    private final Integer id;
    private final Integer nodeId;
    private final InetAddress ospfAreaId;
    private final Integer ospfAuthType;
    private final Integer ospfImportAsExtern;
    private final Integer ospfAreaBdrRtrCount;
    private final Integer ospfAsBdrRtrCount;
    private final Integer ospfAreaLsaCount;

    public OspfAreaTopologyEntity(Integer id, Integer nodeId, InetAddress ospfAreaId, Integer ospfAuthType, Integer ospfImportAsExtern, Integer ospfAreaBdrRtrCount, Integer ospfAsBdrRtrCount, Integer ospfAreaLsaCount) {
        this.id = id;
        this.nodeId = nodeId;
        this.ospfAreaId = ospfAreaId;
        this.ospfAuthType = ospfAuthType;
        this.ospfImportAsExtern = ospfImportAsExtern;
        this.ospfAreaBdrRtrCount = ospfAreaBdrRtrCount;
        this.ospfAsBdrRtrCount = ospfAsBdrRtrCount;
        this.ospfAreaLsaCount = ospfAreaLsaCount;
    }

    public static OspfAreaTopologyEntity create(OspfArea area) {
        return new OspfAreaTopologyEntity(area.getId(), area.getNode().getId(), area.getOspfAreaId(), area.getOspfAuthType(), area.getOspfImportAsExtern(), area.getOspfAreaBdrRtrCount(), area.getOspfAsBdrRtrCount(), area.getOspfAreaLsaCount());
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String getNodeIdAsString() {
        if (this.getNodeId() != null) {
            return this.getNodeId().toString();
        }
        return null;
    }

    public InetAddress getOspfAreaId() {
        return this.ospfAreaId;
    }

    public Integer getOspfAuthType() {
        return this.ospfAuthType;
    }

    public Integer getOspfImportAsExtern() {
        return this.ospfImportAsExtern;
    }

    public Integer getOspfAreaBdrRtrCount() {
        return this.ospfAreaBdrRtrCount;
    }

    public Integer getOspfAsBdrRtrCount() {
        return this.ospfAsBdrRtrCount;
    }

    public Integer getOspfAreaLsaCount() {
        return this.ospfAreaLsaCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("nodeId", (Object)this.nodeId).add("ospfAreaId", (Object)this.ospfAreaId).add("ospfAuthType", (Object)this.ospfAuthType).add("ospfImportAsExtern", (Object)this.ospfImportAsExtern).add("ospfAreaBdrRtrCount", (Object)this.ospfAreaBdrRtrCount).add("ospfAsBdrRtrCount", (Object)this.ospfAsBdrRtrCount).add("ospfAreaLsaCount", (Object)this.ospfAreaLsaCount).toString();
    }
}

