/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.util.Optional;
import org.opennms.netmgt.enlinkd.model.CdpElement;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.ReadOnlyEntity;

@ReadOnlyEntity
public class CdpElementTopologyEntity {
    private final Integer id;
    private final String cdpGlobalDeviceId;
    private final Integer nodeId;

    public CdpElementTopologyEntity(Integer id, String cdpGlobalDeviceId, Integer nodeId) {
        this.id = id;
        this.cdpGlobalDeviceId = cdpGlobalDeviceId;
        this.nodeId = nodeId;
    }

    public static CdpElementTopologyEntity create(CdpElement element) {
        return new CdpElementTopologyEntity(element.getId(), element.getCdpGlobalDeviceId(), Optional.ofNullable(element.getNode()).map(OnmsNode::getId).orElse(null));
    }

    public Integer getId() {
        return this.id;
    }

    public String getCdpGlobalDeviceId() {
        return this.cdpGlobalDeviceId;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }
}

