/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.RrdNode;
import org.jrobin.inspector.Util;

class MainTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private static final DefaultMutableTreeNode INVALID_NODE = new DefaultMutableTreeNode("No valid RRD file specified");

    MainTreeModel() {
        super(INVALID_NODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setFile(File file) {
        try {
            RrdDb rrd = new RrdDb(file.getAbsolutePath(), true);
            try {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(new RrdNode(rrd));
                int dsCount = rrd.getRrdDef().getDsCount();
                int arcCount = rrd.getRrdDef().getArcCount();
                for (int dsIndex = 0; dsIndex < dsCount; ++dsIndex) {
                    DefaultMutableTreeNode dsNode = new DefaultMutableTreeNode(new RrdNode(rrd, dsIndex));
                    for (int arcIndex = 0; arcIndex < arcCount; ++arcIndex) {
                        DefaultMutableTreeNode arcNode = new DefaultMutableTreeNode(new RrdNode(rrd, dsIndex, arcIndex));
                        dsNode.add(arcNode);
                    }
                    root.add(dsNode);
                }
                this.setRoot(root);
            }
            finally {
                rrd.close();
            }
            return true;
        }
        catch (IOException e) {
            this.setRoot(INVALID_NODE);
            Util.error(null, e);
        }
        catch (RrdException e) {
            this.setRoot(INVALID_NODE);
            Util.error(null, e);
        }
        return false;
    }
}

