/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors;

import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandlerMBeanProxy
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EventHandlerMBeanProxy.class);
    private MBeanServer m_mbserver;
    private ObjectName m_listener;

    private void findServer() throws InstanceNotFoundException {
        for (MBeanServer sx : this.findMBeanServers()) {
            try {
                if (sx.getObjectInstance(this.m_listener) == null) continue;
                this.m_mbserver = sx;
                break;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
        }
        if (this.m_mbserver == null) {
            throw new InstanceNotFoundException("could not locate mbean server instance");
        }
    }

    private List<MBeanServer> findMBeanServers() {
        return MBeanServerFactory.findMBeanServer(null);
    }

    public EventHandlerMBeanProxy(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.m_listener = new ObjectName(name);
        this.findServer();
    }

    public EventHandlerMBeanProxy(ObjectName name) throws InstanceNotFoundException {
        this.m_listener = name;
        this.findServer();
    }

    public EventHandlerMBeanProxy(ObjectName name, MBeanServer server) {
        this.m_listener = name;
        this.m_mbserver = server;
    }

    @Override
    public boolean processEvent(Event event) {
        boolean result = false;
        try {
            result = (Boolean)this.m_mbserver.invoke(this.m_listener, "processEvent", new Object[]{event}, new String[]{"org.opennms.netmgt.xml.event.Event"});
        }
        catch (Throwable t) {
            LOG.warn("Invocation on object {} failed", (Object)t, (Object)this.m_listener);
        }
        return result;
    }

    @Override
    public void receiptSent(EventReceipt receipt) {
        try {
            this.m_mbserver.invoke(this.m_listener, "receiptSent", new Object[]{receipt}, new String[]{"org.opennms.netmgt.xml.event.EventReceipt"});
        }
        catch (Throwable t) {
            LOG.warn("Invocation on object {} failed", (Object)t, (Object)this.m_listener);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(9, 13).append((Object)this.m_mbserver).append((Object)this.m_listener).toHashCode();
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (this == obj) {
            rc = true;
        } else if (obj != null && obj instanceof EventHandlerMBeanProxy) {
            EventHandlerMBeanProxy p = (EventHandlerMBeanProxy)obj;
            if (p.m_mbserver.equals(this.m_mbserver) && p.m_listener.equals(this.m_listener)) {
                rc = true;
            }
        }
        return rc;
    }
}

