/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import org.opennms.core.time.YearGuesser;
import org.opennms.netmgt.syslogd.SyslogMessage;

public class SyslogYearCompleter {
    public static void complete(SyslogMessage syslog) {
        SyslogYearCompleter.complete(syslog, Instant.now());
    }

    public static void complete(SyslogMessage syslog, Instant referenceTime) {
        if (syslog.getYear() != null) {
            return;
        }
        ZoneId zoneId = Optional.ofNullable(syslog.getZoneId()).orElse(ZoneId.systemDefault());
        LocalDateTime localReferenceTime = LocalDateTime.ofInstant(referenceTime, zoneId);
        LocalDateTime syslogDateTime = LocalDateTime.of(0, SyslogYearCompleter.toValueOr1(syslog.getMonth()), (int)SyslogYearCompleter.toValueOr1(syslog.getDayOfMonth()), (int)SyslogYearCompleter.toValueOr0(syslog.getHourOfDay()), (int)SyslogYearCompleter.toValueOr0(syslog.getMinute()), (int)SyslogYearCompleter.toValueOr0(syslog.getSecond()), (int)SyslogYearCompleter.toValueOr0(syslog.getMillisecond()));
        int year = YearGuesser.guessYearForDate((LocalDateTime)syslogDateTime, (LocalDateTime)localReferenceTime).getYear();
        syslog.setYear(year);
    }

    private static Integer toValueOr0(Integer integer) {
        return Optional.ofNullable(integer).orElse(0);
    }

    private static Integer toValueOr1(Integer integer) {
        return Optional.ofNullable(integer).orElse(1);
    }
}

