/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.elastic;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.TopHitsAggregation;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.alarms.history.api.AlarmHistoryRepository;
import org.opennms.features.alarms.history.api.AlarmState;
import org.opennms.features.alarms.history.elastic.CompositeAggregation;
import org.opennms.features.alarms.history.elastic.QueryProvider;
import org.opennms.features.alarms.history.elastic.TimeRange;
import org.opennms.features.alarms.history.elastic.dto.AlarmDocumentDTO;
import org.opennms.features.jest.client.index.IndexSelector;
import org.opennms.features.jest.client.index.IndexStrategy;
import org.opennms.features.jest.client.template.IndexSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticAlarmHistoryRepository
implements AlarmHistoryRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticAlarmHistoryRepository.class);
    public static final long DEFAULT_LOOKBACK_PERIOD_MS = TimeUnit.DAYS.toMillis(7L);
    private final JestClient client;
    private final IndexSelector indexSelector;
    private final QueryProvider queryProvider = new QueryProvider();
    private long lookbackPeriodMs = DEFAULT_LOOKBACK_PERIOD_MS;

    public ElasticAlarmHistoryRepository(JestClient client, IndexStrategy indexStrategy, IndexSettings indexSettings) {
        this.client = Objects.requireNonNull(client);
        Objects.requireNonNull(indexStrategy);
        this.indexSelector = new IndexSelector(indexSettings, "opennms-alarms", indexStrategy, 0L);
    }

    public Optional<AlarmState> getAlarmWithDbIdAt(long id, long time) {
        TimeRange timeRange = this.getTimeRange(time);
        return this.findAlarms(this.queryProvider.getAlarmByDbIdAt(id, timeRange), timeRange).stream().findFirst().map(a -> a);
    }

    public Optional<AlarmState> getAlarmWithReductionKeyIdAt(String reductionKey, long time) {
        TimeRange timeRange = this.getTimeRange(time);
        return this.findAlarms(this.queryProvider.getAlarmByReductionKeyAt(reductionKey, timeRange), timeRange).stream().findFirst().map(a -> a);
    }

    public List<AlarmState> getStatesForAlarmWithDbId(long id) {
        return this.findAlarms(this.queryProvider.getAlarmStatesByDbId(id), null).stream().map(a -> a).collect(Collectors.toList());
    }

    public List<AlarmState> getStatesForAlarmWithReductionKey(String reductionKey) {
        return this.findAlarms(this.queryProvider.getAlarmStatesByReductionKey(reductionKey), null).stream().map(a -> a).collect(Collectors.toList());
    }

    public List<AlarmState> getActiveAlarmsAt(long time) {
        TimeRange timeRange = this.getTimeRange(time);
        return this.findAlarmsWithCompositeAggregation(afterAlarmWithId -> this.queryProvider.getActiveAlarmsAt(timeRange, (Integer)afterAlarmWithId), timeRange).stream().map(a -> a).collect(Collectors.toList());
    }

    public List<AlarmState> getLastStateOfAllAlarms(long start, long end) {
        TimeRange timeRange = new TimeRange(start, end);
        return this.findAlarmsWithCompositeAggregation(afterAlarmWIthId -> this.queryProvider.getAllAlarms(timeRange, (Integer)afterAlarmWIthId), timeRange).stream().map(a -> a).collect(Collectors.toList());
    }

    public long getNumActiveAlarmsAt(long time) {
        TimeRange timeRange = this.getTimeRange(time);
        return this.findAlarmsWithCompositeAggregation(afterAlarmWithId -> this.queryProvider.getActiveAlarmIdsAt(timeRange, (Integer)afterAlarmWithId), timeRange).size();
    }

    public List<AlarmState> getActiveAlarmsNow() {
        return this.getActiveAlarmsAt(System.currentTimeMillis());
    }

    public long getNumActiveAlarmsNow() {
        return this.getNumActiveAlarmsAt(System.currentTimeMillis());
    }

    private List<AlarmDocumentDTO> findAlarmsWithCompositeAggregation(Function<Integer, String> getNextQuery, TimeRange timeRange) {
        LinkedList<AlarmDocumentDTO> alarms = new LinkedList<AlarmDocumentDTO>();
        Integer afterAlarmWithId = null;
        while (true) {
            SearchResult result;
            String query = getNextQuery.apply(afterAlarmWithId);
            Search.Builder search = new Search.Builder(query);
            if (timeRange != null) {
                List indices = this.indexSelector.getIndexNames(timeRange.getStart(), timeRange.getEnd());
                search.addIndices((Collection)indices);
                search.setParameter("ignore_unavailable", (Object)"true");
                LOG.debug("Executing query on {}: {}", (Object)indices, (Object)query);
            } else {
                search.addIndex("opennms-alarms-*");
                LOG.debug("Executing query on all indices: {}", (Object)query);
            }
            try {
                result = (SearchResult)this.client.execute((Action)search.build());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!result.isSucceeded()) {
                throw new RuntimeException(result.getErrorMessage());
            }
            CompositeAggregation alarmsById = (CompositeAggregation)result.getAggregations().getAggregation("alarms_by_id", CompositeAggregation.class);
            if (alarmsById == null) break;
            for (CompositeAggregation.Entry entry : alarmsById.getBuckets()) {
                TopHitsAggregation topHitsAggregation = entry.getTopHitsAggregation("latest_alarm");
                List hits = topHitsAggregation.getHits(AlarmDocumentDTO.class);
                hits.stream().map(h -> (AlarmDocumentDTO)h.source).forEach(alarms::add);
            }
            if (!alarmsById.hasAfterKey()) break;
            afterAlarmWithId = alarmsById.getAfterKey().get("alarm_id").getAsInt();
        }
        return alarms;
    }

    private TimeRange getTimeRange(long time) {
        return new TimeRange(Math.max(time - this.lookbackPeriodMs, 0L), time);
    }

    private List<AlarmDocumentDTO> findAlarms(String query, TimeRange timeRange) {
        SearchResult result;
        Search.Builder search = new Search.Builder(query);
        if (timeRange != null) {
            List indices = this.indexSelector.getIndexNames(timeRange.getStart(), timeRange.getEnd());
            search.addIndices((Collection)indices);
            search.setParameter("ignore_unavailable", (Object)"true");
            LOG.debug("Executing query on {}: {}", (Object)indices, (Object)query);
        } else {
            search.addIndex("opennms-alarms-*");
            LOG.debug("Executing query on all indices: {}", (Object)query);
        }
        try {
            result = (SearchResult)this.client.execute((Action)search.build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!result.isSucceeded()) {
            throw new RuntimeException(result.getErrorMessage());
        }
        List hits = result.getHits(AlarmDocumentDTO.class);
        return hits.stream().map(h -> (AlarmDocumentDTO)h.source).collect(Collectors.toList());
    }

    public void setLookbackPeriodMs(long lookbackPeriodMs) {
        this.lookbackPeriodMs = lookbackPeriodMs;
    }
}

