/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.elastic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.Aggregation;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class CompositeAggregation
extends Aggregation {
    private static final String AFTER_KEY = "after_key";
    private JsonObject after_key;
    private List<Entry> buckets = new LinkedList<Entry>();

    public CompositeAggregation(String name, JsonObject compositeAggregation) {
        super(name, compositeAggregation);
        this.after_key = compositeAggregation.getAsJsonObject(AFTER_KEY);
        this.parseBuckets(compositeAggregation.get(String.valueOf(AggregationField.BUCKETS)).getAsJsonArray());
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucketElement : bucketsSource) {
            JsonObject bucket = (JsonObject)bucketElement;
            this.buckets.add(new Entry(bucket, bucket.get(String.valueOf(AggregationField.KEY)), bucket.get(String.valueOf(AggregationField.DOC_COUNT)).getAsLong()));
        }
    }

    public boolean hasAfterKey() {
        return this.after_key != null;
    }

    public JsonObject getAfterKey() {
        return this.after_key;
    }

    public List<Entry> getBuckets() {
        return this.buckets;
    }

    public class Entry
    extends Bucket {
        private final Object key;

        public Entry(JsonObject bucket, Object key, Long count) {
            super(bucket, count);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Entry entry = (Entry)((Object)o);
            return Objects.equals(this.key, entry.key);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.key);
        }
    }
}

