/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Where;
import org.opennms.netmgt.graph.AbstractGraphEntity;
import org.opennms.netmgt.graph.GraphEntity;

@Entity
@DiscriminatorValue(value="container")
public class GraphContainerEntity
extends AbstractGraphEntity {
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="graph_element_relations", joinColumns={@JoinColumn(name="parent_id", referencedColumnName="id", nullable=false, updatable=true)}, inverseJoinColumns={@JoinColumn(name="child_id", referencedColumnName="id", nullable=false, updatable=true)})
    @Where(clause="TYPE='graph'")
    @BatchSize(size=1000)
    private List<GraphEntity> graphs = new ArrayList<GraphEntity>();

    public List<GraphEntity> getGraphs() {
        return this.graphs;
    }

    public void setGraphs(List<GraphEntity> graphs) {
        this.graphs = graphs;
    }

    public GraphEntity getGraph(String namespace) {
        return this.graphs.stream().filter(graphEntity -> graphEntity.getNamespace().equals(namespace)).findAny().orElseThrow(() -> new NoSuchElementException("No graph with namespace '" + namespace + "' found"));
    }

    public String getLabel() {
        return this.getPropertyValue("label");
    }

    public String getDescription() {
        return this.getPropertyValue("description");
    }

    public void removeGraph(String namespace) {
        GraphEntity graphToRemove = this.getGraph(namespace);
        this.getGraphs().remove(graphToRemove);
    }
}

