/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph;

import java.util.Objects;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import org.opennms.netmgt.graph.AbstractGraphEntity;
import org.opennms.netmgt.graph.VertexRefEntity;

@Entity
@DiscriminatorValue(value="edge")
public class EdgeEntity
extends AbstractGraphEntity {
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="namespace", column=@Column(name="source_vertex_namespace")), @AttributeOverride(name="id", column=@Column(name="source_vertex_id"))})
    private VertexRefEntity source;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="namespace", column=@Column(name="target_vertex_namespace")), @AttributeOverride(name="id", column=@Column(name="target_vertex_id"))})
    private VertexRefEntity target;

    public VertexRefEntity getSource() {
        return this.source;
    }

    public void setSource(String namespace, String id) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(id);
        this.setSource(new VertexRefEntity(namespace, id));
    }

    public void setSource(VertexRefEntity source) {
        Objects.requireNonNull(source, "source can not be null");
        this.source = source;
    }

    public VertexRefEntity getTarget() {
        return this.target;
    }

    public void setTarget(String namespace, String id) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(id);
        this.setTarget(new VertexRefEntity(namespace, id));
    }

    public void setTarget(VertexRefEntity target) {
        Objects.requireNonNull(target, "target can not be null");
        this.target = target;
    }
}

