/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.BatchSize;
import org.opennms.netmgt.graph.PropertyEntity;

@Entity(name="graph_elements")
@Table(name="graph_elements")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.STRING)
public class AbstractGraphEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="graphSequence")
    @SequenceGenerator(name="graphSequence", sequenceName="graphnxtid")
    @Column(name="id", nullable=false)
    private Long dbId;
    @Column(name="namespace", nullable=false)
    private String namespace;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="element_id", referencedColumnName="id", nullable=false, updatable=true)
    @BatchSize(size=1000)
    private List<PropertyEntity> properties = new ArrayList<PropertyEntity>();

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<PropertyEntity> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyEntity> properties) {
        this.properties = properties;
    }

    public PropertyEntity getProperty(String key) {
        return this.properties.stream().filter(p -> p.getName().equalsIgnoreCase(key)).findFirst().orElse(null);
    }

    public void mergeProperties(List<PropertyEntity> propertyEntities) {
        for (PropertyEntity propertyEntity : propertyEntities) {
            PropertyEntity alreadyExisting = this.getProperty(propertyEntity.getName());
            if (alreadyExisting != null) {
                alreadyExisting.setType(propertyEntity.getType());
                alreadyExisting.setValue(propertyEntity.getValue());
                continue;
            }
            this.getProperties().add(propertyEntity);
        }
        if (this.getProperties().size() != propertyEntities.size()) {
            List newPropertyNames = propertyEntities.stream().map(pe -> pe.getName()).collect(Collectors.toList());
            List<String> allPropertyNames = this.getProperties().stream().map(pe -> pe.getName()).collect(Collectors.toList());
            allPropertyNames.removeAll(newPropertyNames);
            allPropertyNames.forEach(propertyName -> this.getProperties().remove(this.getProperty((String)propertyName)));
        }
    }

    public void setProperty(String key, Class<?> type, String stringValue) {
        PropertyEntity existingProperty = this.getProperty(key);
        if (existingProperty != null) {
            if (stringValue == null) {
                this.properties.remove(existingProperty);
            } else {
                existingProperty.setType(type);
                existingProperty.setValue(stringValue);
            }
        } else if (stringValue != null) {
            PropertyEntity propertyEntity = new PropertyEntity();
            propertyEntity.setType(type);
            propertyEntity.setName(key);
            propertyEntity.setValue(stringValue);
            this.properties.add(propertyEntity);
        }
    }

    protected String getPropertyValue(String key) {
        PropertyEntity property = this.getProperty(key);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }
}

