/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.PingResponseCallback;

public class ParallelPingResponseCallback
implements PingResponseCallback {
    CountDownLatch m_latch;
    Number[] m_responseTimes;
    Throwable m_error;

    public ParallelPingResponseCallback(int count) {
        this.m_latch = new CountDownLatch(count);
        this.m_responseTimes = new Number[count];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(InetAddress address, EchoPacket request, Throwable t) {
        try {
            if (request != null) {
                this.m_responseTimes[request.getSequenceNumber()] = null;
            }
            this.m_error = t;
        }
        finally {
            this.m_latch.countDown();
        }
    }

    @Override
    public void handleResponse(InetAddress address, EchoPacket response) {
        try {
            if (response != null) {
                this.m_responseTimes[response.getSequenceNumber()] = response.elapsedTime(TimeUnit.MICROSECONDS);
            }
        }
        finally {
            this.m_latch.countDown();
        }
    }

    @Override
    public void handleTimeout(InetAddress address, EchoPacket request) {
        try {
            if (request != null) {
                this.m_responseTimes[request.getSequenceNumber()] = null;
            }
        }
        finally {
            this.m_latch.countDown();
        }
    }

    public void waitFor() throws InterruptedException {
        this.m_latch.await();
    }

    public void rethrowError() throws Exception {
        if (this.m_error instanceof Error) {
            throw (Error)this.m_error;
        }
        if (this.m_error instanceof Exception) {
            throw (Exception)this.m_error;
        }
    }

    public List<Number> getResponseTimes() {
        return Arrays.asList(this.m_responseTimes);
    }
}

