/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tracing.util;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.propagation.TextMapAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.XmlHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="tracing-info")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TracingInfoCarrier
implements TextMap {
    private static final Logger LOG = LoggerFactory.getLogger(TracingInfoCarrier.class);
    private Map<String, String> tracingInfoMap = new HashMap<String, String>();

    public TracingInfoCarrier(Map<String, String> tracingInfo) {
        this.tracingInfoMap = tracingInfo;
    }

    public TracingInfoCarrier() {
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.tracingInfoMap.entrySet().iterator();
    }

    public void put(String key, String value) {
        this.tracingInfoMap.put(key, value);
    }

    public Map<String, String> getTracingInfoMap() {
        return this.tracingInfoMap;
    }

    public void setTracingInfoMap(Map<String, String> tracingInfoMap) {
        this.tracingInfoMap = tracingInfoMap;
    }

    public static String marshalTracingInfo(Map<String, String> tracingInfo) {
        try {
            TracingInfoCarrier tracingInfoCarrier = new TracingInfoCarrier(tracingInfo);
            return TracingInfoMarshaller.marshalRequest(tracingInfoCarrier);
        }
        catch (Exception e) {
            LOG.warn("Exception while marshalling tracing info {}", tracingInfo, (Object)e);
            return null;
        }
    }

    public static Map<String, String> unmarshalTracinginfo(String tracingInfo) {
        try {
            TracingInfoCarrier tracingInfoCarrier = TracingInfoMarshaller.unmarshalRequest(tracingInfo);
            return tracingInfoCarrier.getTracingInfoMap();
        }
        catch (Exception e) {
            LOG.warn("Exception while unmarshalling tracing info {}", (Object)tracingInfo, (Object)e);
            return new HashMap<String, String>();
        }
    }

    public static void updateTracingMetadata(Tracer tracer, Span span, BiConsumer<String, String> tracingInfoConsumer) {
        TracingInfoCarrier tracingInfoCarrier = new TracingInfoCarrier();
        tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)tracingInfoCarrier);
        tracingInfoCarrier.getTracingInfoMap().forEach(tracingInfoConsumer);
    }

    public static Tracer.SpanBuilder buildSpanFromTracingMetadata(Tracer tracer, String tracingOperationKey, Map<String, String> tracingMetadata, String reference) {
        SpanContext context = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(tracingMetadata));
        Tracer.SpanBuilder spanBuilder = context != null && ("child_of".equals(reference) || "follows_from".equals(reference)) ? tracer.buildSpan(tracingOperationKey).addReference(reference, context) : tracer.buildSpan(tracingOperationKey);
        return spanBuilder;
    }

    private static class TracingInfoMarshaller {
        private static final ThreadLocal<XmlHandler<TracingInfoCarrier>> xmlHandlerThreadLocal = new ThreadLocal();

        private TracingInfoMarshaller() {
        }

        public static String marshalRequest(TracingInfoCarrier tracingInfo) {
            return TracingInfoMarshaller.createXmlHandler().marshal((Object)tracingInfo);
        }

        public static TracingInfoCarrier unmarshalRequest(String tracingInfo) {
            return (TracingInfoCarrier)TracingInfoMarshaller.createXmlHandler().unmarshal(tracingInfo);
        }

        private static XmlHandler<TracingInfoCarrier> createXmlHandler() {
            XmlHandler xmlHandler = xmlHandlerThreadLocal.get();
            if (xmlHandler == null) {
                xmlHandler = new XmlHandler(TracingInfoCarrier.class);
                xmlHandlerThreadLocal.set((XmlHandler<TracingInfoCarrier>)xmlHandler);
            }
            return xmlHandler;
        }
    }
}

