/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.rdns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

public class ReverseDNSLookupDetector
extends SyncAbstractDetector {
    private static final Logger LOG = LoggerFactory.getLogger(ReverseDNSLookupDetector.class);
    private static final String SERVICE_NAME = "Reverse-DNS-Lookup";

    public ReverseDNSLookupDetector() {
        super(SERVICE_NAME, -1);
    }

    public boolean isServiceDetected(InetAddress address) {
        String hostName = address.getCanonicalHostName();
        if (InetAddressUtils.str((InetAddress)address).equals(hostName)) {
            try {
                hostName = Address.getHostName((InetAddress)address);
                if (!InetAddressUtils.str((InetAddress)address).equals(hostName)) {
                    return true;
                }
            }
            catch (UnknownHostException e) {
                LOG.warn("Failed to retrieve domain/hostname for {}.", (Object)address);
            }
            catch (Exception e) {
                LOG.warn("Unknown exception while retrieving domain/hostname for {}.", (Object)address);
            }
        } else {
            return true;
        }
        return false;
    }

    protected void onInit() {
    }

    public void dispose() {
    }
}

