/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.ApplicationConfiguration;
import com.eclipsesource.jaxrs.publisher.JerseyContextFactory;
import com.eclipsesource.jaxrs.publisher.ServletConfiguration;
import com.eclipsesource.jaxrs.publisher.api.ApplicationRegistry;
import com.eclipsesource.jaxrs.publisher.internal.ApplicationRegistryImpl;
import com.eclipsesource.jaxrs.publisher.internal.Configuration;
import com.eclipsesource.jaxrs.publisher.internal.DefaultJerseyContextFactory;
import com.eclipsesource.jaxrs.publisher.internal.JerseyContext;
import com.eclipsesource.jaxrs.publisher.internal.ServiceContainer;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

public class JAXRSConnector {
    private static final String HTTP_SERVICE_PORT_PROPERTY = "org.osgi.service.http.port";
    private static final String RESOURCE_HTTP_PORT_PROPERTY = "http.port";
    private static final String DEFAULT_HTTP_PORT = "80";
    private final Object lock = new Object();
    private final ServiceContainer httpServices;
    private final ServiceContainer resources;
    private final BundleContext bundleContext;
    private final List<ServiceContainer.ServiceHolder> resourceCache;
    private ServletConfiguration servletConfiguration;
    private final ServiceContainer applicationConfigurations;
    private ApplicationRegistryImpl applicationRegistry;

    JAXRSConnector(BundleContext bundleContext) {
        this(bundleContext, new DefaultJerseyContextFactory());
    }

    JAXRSConnector(BundleContext bundleContext, JerseyContextFactory jerseyContextFactory) {
        this.bundleContext = bundleContext;
        this.httpServices = new ServiceContainer(bundleContext);
        this.resources = new ServiceContainer(bundleContext);
        this.resourceCache = new ArrayList<ServiceContainer.ServiceHolder>();
        this.applicationConfigurations = new ServiceContainer(bundleContext);
        this.applicationRegistry = new ApplicationRegistryImpl(new Configuration(this), bundleContext, jerseyContextFactory);
        bundleContext.registerService(ApplicationRegistry.class, (Object)this.applicationRegistry, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfiguration(Configuration configuration) {
        Object object = this.lock;
        synchronized (object) {
            this.doUpdateConfiguration(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpService addHttpService(ServiceReference reference) {
        Object object = this.lock;
        synchronized (object) {
            return this.doAddHttpService(reference);
        }
    }

    ServletConfiguration setServletConfiguration(ServiceReference reference) {
        if (this.servletConfiguration == null) {
            this.servletConfiguration = (ServletConfiguration)this.bundleContext.getService(reference);
            this.doUpdateServletConfiguration();
            return this.servletConfiguration;
        }
        return null;
    }

    void unsetServletConfiguration(ServiceReference reference, ServletConfiguration service) {
        if (this.servletConfiguration == service) {
            this.servletConfiguration = null;
            this.bundleContext.ungetService(reference);
            this.doUpdateServletConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationConfiguration addApplicationConfiguration(ServiceReference reference) {
        Object object = this.lock;
        synchronized (object) {
            ApplicationConfiguration service = (ApplicationConfiguration)this.applicationConfigurations.add(reference).getService();
            this.doUpdateAppConfiguration();
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeApplicationConfiguration(ServiceReference reference, ApplicationConfiguration service) {
        Object object = this.lock;
        synchronized (object) {
            this.applicationConfigurations.remove(service);
            this.doUpdateAppConfiguration();
        }
    }

    private void doUpdateServletConfiguration() {
        ServiceContainer.ServiceHolder[] services;
        for (ServiceContainer.ServiceHolder serviceHolder : services = this.httpServices.getServices()) {
            this.applicationRegistry.updateServletConfiguration((HttpService)serviceHolder.getService(), this.servletConfiguration);
        }
    }

    private void doUpdateAppConfiguration() {
        ServiceContainer.ServiceHolder[] services;
        for (ServiceContainer.ServiceHolder serviceHolder : services = this.httpServices.getServices()) {
            this.applicationRegistry.updateAppConfiguration((HttpService)serviceHolder.getService(), this.applicationConfigurations);
        }
    }

    private void doUpdateConfiguration(Configuration configuration) {
        ServiceContainer.ServiceHolder[] services;
        for (ServiceContainer.ServiceHolder serviceHolder : services = this.httpServices.getServices()) {
            this.applicationRegistry.updateConfiguration((HttpService)serviceHolder.getService(), configuration);
        }
    }

    HttpService doAddHttpService(ServiceReference reference) {
        ServiceContainer.ServiceHolder serviceHolder = this.httpServices.add(reference);
        HttpService service = (HttpService)serviceHolder.getService();
        this.clearCache();
        return service;
    }

    private void clearCache() {
        ArrayList<ServiceContainer.ServiceHolder> cache = new ArrayList<ServiceContainer.ServiceHolder>(this.resourceCache);
        this.resourceCache.clear();
        for (ServiceContainer.ServiceHolder serviceHolder : cache) {
            this.registerResource(serviceHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHttpService(HttpService service) {
        Object object = this.lock;
        synchronized (object) {
            this.doRemoveHttpService(service);
        }
    }

    void doRemoveHttpService(HttpService service) {
        List<JerseyContext> contexts = this.applicationRegistry.removeHttpService(service);
        if (contexts != null) {
            contexts.forEach(context -> this.cacheFreedResources((JerseyContext)context));
        }
        this.httpServices.remove(service);
    }

    private void cacheFreedResources(JerseyContext context) {
        List<Object> freeResources = context.eliminate();
        for (Object resource : freeResources) {
            this.resourceCache.add(this.resources.find(resource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object addResource(ServiceReference reference) {
        Object object = this.lock;
        synchronized (object) {
            return this.doAddResource(reference);
        }
    }

    private Object doAddResource(ServiceReference reference) {
        ServiceContainer.ServiceHolder serviceHolder = this.resources.add(reference);
        this.registerResource(serviceHolder);
        return serviceHolder.getService();
    }

    private void registerResource(ServiceContainer.ServiceHolder serviceHolder) {
        Object port = this.getPort(serviceHolder);
        this.registerResource(serviceHolder, port);
    }

    private Object getPort(ServiceContainer.ServiceHolder serviceHolder) {
        Object port = serviceHolder.getReference().getProperty(RESOURCE_HTTP_PORT_PROPERTY);
        if (port == null && (port = this.bundleContext.getProperty(HTTP_SERVICE_PORT_PROPERTY)) == null) {
            port = DEFAULT_HTTP_PORT;
        }
        return port;
    }

    private void registerResource(ServiceContainer.ServiceHolder serviceHolder, Object port) {
        HttpService httpService = this.findHttpServiceForPort(port);
        if (httpService != null) {
            this.applicationRegistry.addResource(httpService, serviceHolder.getService(), serviceHolder.getProperties());
        } else {
            this.cacheResource(serviceHolder);
        }
    }

    private void cacheResource(ServiceContainer.ServiceHolder serviceHolder) {
        this.resourceCache.add(serviceHolder);
    }

    private HttpService findHttpServiceForPort(Object port) {
        ServiceContainer.ServiceHolder[] serviceHolders = this.httpServices.getServices();
        HttpService result = null;
        for (ServiceContainer.ServiceHolder serviceHolder : serviceHolders) {
            Object servicePort = this.getPort(serviceHolder);
            if (!servicePort.equals(port)) continue;
            result = (HttpService)serviceHolder.getService();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResource(Object resource) {
        Object object = this.lock;
        synchronized (object) {
            this.doRemoveResource(resource);
        }
    }

    private void doRemoveResource(Object resource) {
        ServiceContainer.ServiceHolder serviceHolder = this.resources.find(resource);
        this.resourceCache.remove(serviceHolder);
        HttpService httpService = this.findHttpServiceForPort(this.getPort(serviceHolder));
        this.applicationRegistry.removeResource(httpService, resource, serviceHolder.getProperties());
        this.resources.remove(resource);
    }
}

