/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.situationfeedback.rest;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import org.opennms.features.situationfeedback.api.AlarmFeedback;
import org.opennms.features.situationfeedback.api.FeedbackException;
import org.opennms.features.situationfeedback.api.FeedbackRepository;
import org.opennms.features.situationfeedback.rest.SituationFeedbackRestService;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SituationFeedbackRestServiceImpl
implements SituationFeedbackRestService {
    private static final Logger LOG = LoggerFactory.getLogger(SituationFeedbackRestServiceImpl.class);
    private final AlarmDao alarmDao;
    private final FeedbackRepository repository;

    public SituationFeedbackRestServiceImpl(AlarmDao alarmDao, FeedbackRepository feedbackRepository) {
        this.alarmDao = Objects.requireNonNull(alarmDao);
        this.repository = Objects.requireNonNull(feedbackRepository);
    }

    @Override
    public Collection<String> getTags(String prefix) {
        try {
            return this.repository.getTags(prefix);
        }
        catch (FeedbackException e) {
            LOG.error("Error retrieving tags for [{}]: {}", (Object)prefix, (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    @Override
    public Collection<AlarmFeedback> getFeedback(int situationId) {
        try {
            return this.repository.getFeedback(this.getReductionKey(situationId));
        }
        catch (FeedbackException e) {
            LOG.error("Error retrieving alarm correlation feedback for [{}]: {}", (Object)situationId, (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    private String getReductionKey(int situationId) throws FeedbackException {
        OnmsAlarm situation = (OnmsAlarm)this.alarmDao.get((Serializable)Integer.valueOf(situationId));
        if (situation == null) {
            throw new FeedbackException("No Situation found with ID " + situationId);
        }
        return situation.getReductionKey();
    }

    @Override
    public void setFeedback(int situationId, List<AlarmFeedback> feedback) {
        try {
            this.repository.persist(feedback);
        }
        catch (Exception e) {
            throw new WebApplicationException("Failed to execute query: " + e.getMessage(), (Throwable)e);
        }
    }
}

