/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import org.jfree.util.PublicCloneable;
import org.opennms.shaded.jasper.org.jfree.chart.HashUtilities;
import org.opennms.shaded.jasper.org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.opennms.shaded.jasper.org.jfree.chart.util.ParamChecks;
import org.opennms.shaded.jasper.org.jfree.data.xy.XYDataset;

public class StandardXYSeriesLabelGenerator
implements XYSeriesLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1916017081848400024L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;

    public StandardXYSeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public StandardXYSeriesLabelGenerator(String format) {
        ParamChecks.nullNotPermitted(format, "format");
        this.formatPattern = format;
    }

    @Override
    public String generateLabel(XYDataset dataset, int series) {
        ParamChecks.nullNotPermitted(dataset, "dataset");
        String label = MessageFormat.format(this.formatPattern, this.createItemArray(dataset, series));
        return label;
    }

    protected Object[] createItemArray(XYDataset dataset, int series) {
        Object[] result = new Object[]{dataset.getSeriesKey(series).toString()};
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardXYSeriesLabelGenerator)) {
            return false;
        }
        StandardXYSeriesLabelGenerator that = (StandardXYSeriesLabelGenerator)obj;
        return this.formatPattern.equals(that.formatPattern);
    }

    public int hashCode() {
        int result = 127;
        result = HashUtilities.hashCode(result, this.formatPattern);
        return result;
    }
}

