/*
 * Decompiled with CFR 0.152.
 */
package org.castor.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingLoaderFactory;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.MappingException;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.MappingLoader;

public final class MappingLoaderRegistry {
    private static final Log LOG = LogFactory.getLog(MappingLoaderRegistry.class);
    private final List<MappingLoaderFactory> _mappingLoaderFactories = new ArrayList<MappingLoaderFactory>();
    private final List<MappingLoader> _mappingLoaders = new ArrayList<MappingLoader>();

    public MappingLoaderRegistry(AbstractProperties properties) {
        Object[] objects;
        for (Object mappingLoaderFactory : objects = properties.getObjectArray("org.castor.mapping.loaderFactories", this.getClass().getClassLoader())) {
            this._mappingLoaderFactories.add((MappingLoaderFactory)mappingLoaderFactory);
        }
    }

    public void clear() {
        for (MappingLoader mappingLoader : this._mappingLoaders) {
            mappingLoader.clear();
        }
    }

    public MappingLoader getMappingLoader(String sourceType, BindingType bindingType) throws MappingException {
        for (MappingLoaderFactory mappingLoaderFactory : this._mappingLoaderFactories) {
            if (!mappingLoaderFactory.getSourceType().equals(sourceType) || mappingLoaderFactory.getBindingType() != bindingType) continue;
            MappingLoader mappingLoader = mappingLoaderFactory.getMappingLoader();
            this._mappingLoaders.add(mappingLoader);
            return mappingLoader;
        }
        String msg = "No mapping loader/factory for: SourceType=" + sourceType + " / BindingType=" + bindingType;
        LOG.error((Object)msg);
        throw new MappingException(msg);
    }

    public Collection<MappingLoaderFactory> getMappingLoaderFactories() {
        return Collections.unmodifiableCollection(this._mappingLoaderFactories);
    }
}

