/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.phantomjs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.ConcurrentMapping;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptManager {
    private static final Log log = LogFactory.getLog(ScriptManager.class);
    private static final String TEMP_FILE_PREFIX = "jr_script_";
    private static final int COPY_BUFFER_SIZE = 16384;
    private final File tempFolder;
    private final ConcurrentMapping<String, File, JasperReportsContext> scriptFiles;
    private JasperReportsContext jasperReportsContext;

    public ScriptManager(JasperReportsContext jasperReportsContext) {
        String tempPath = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty("net.sf.jasperreports.phantomjs.tempdir.path");
        if (tempPath == null) {
            tempPath = System.getProperty("java.io.tmpdir");
        }
        this.tempFolder = new File(tempPath);
        if (this.tempFolder.exists() && this.tempFolder.isDirectory()) {
            log.info((Object)("PhantomJS temp folder is " + tempPath));
        } else {
            log.error((Object)("The PhantomJS temp folder " + tempPath + " does not exist."));
        }
        this.scriptFiles = new ConcurrentMapping<String, File, JasperReportsContext>(new ConcurrentMapping.Mapper<String, File, JasperReportsContext>(){

            @Override
            public File compute(String key, JasperReportsContext jasperReportsContext) {
                return ScriptManager.this.copyScript(key, jasperReportsContext);
            }
        });
        this.jasperReportsContext = jasperReportsContext;
    }

    public File getTempFolder() {
        return this.tempFolder;
    }

    public String getScriptFilename(String scriptLocation) {
        return this.getScriptFilename(scriptLocation, this.jasperReportsContext);
    }

    public String getScriptFilename(String scriptLocation, JasperReportsContext jasperReportsContext) {
        File scriptFile = this.scriptFiles.get(scriptLocation, jasperReportsContext);
        return scriptFile.getName();
    }

    protected File copyScript(String scriptLocation, JasperReportsContext jasperReportsContext) {
        String resourceName = this.getResourceName(scriptLocation);
        try {
            File file = File.createTempFile(TEMP_FILE_PREFIX, "_" + resourceName, this.tempFolder);
            file.deleteOnExit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("copying " + scriptLocation + " to " + file));
            }
            byte[] buf = new byte[16384];
            try (InputStream input = RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(scriptLocation);
                 BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
                int read = 0;
                while ((read = input.read(buf)) > 0) {
                    ((OutputStream)output).write(buf, 0, read);
                }
            }
            return file;
        }
        catch (IOException | JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected String getResourceName(String scriptLocation) {
        int separatorIndex;
        int slashIndex = scriptLocation.lastIndexOf(47);
        int nameIndex = Math.max(slashIndex, separatorIndex = scriptLocation.lastIndexOf(File.separator));
        return nameIndex >= 0 ? scriptLocation.substring(nameIndex + 1) : scriptLocation;
    }

    public void dispose() {
        Iterator<File> fileIt = this.scriptFiles.currentValues();
        while (fileIt.hasNext()) {
            File file = fileIt.next();
            boolean deleted = file.delete();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("deleted " + file + ": " + deleted));
        }
        this.scriptFiles.clear();
    }
}

