/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.export.pdf.PdfChunk;
import net.sf.jasperreports.export.pdf.PdfPhrase;
import net.sf.jasperreports.export.pdf.PdfTextAlignment;
import net.sf.jasperreports.export.pdf.TextDirection;
import net.sf.jasperreports.export.pdf.classic.ClassicChunk;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfProducer;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfUtils;
import org.opennms.shaded.jasper.com.lowagie.text.DocumentException;
import org.opennms.shaded.jasper.com.lowagie.text.Phrase;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.ColumnText;

public class ClassicPhrase
implements PdfPhrase {
    private ClassicPdfProducer pdfProducer;
    private Phrase phrase;

    public ClassicPhrase(ClassicPdfProducer pdfProducer, Phrase phrase) {
        this.pdfProducer = pdfProducer;
        this.phrase = phrase;
    }

    @Override
    public void add(PdfChunk chunk) {
        this.phrase.add(((ClassicChunk)chunk).getChunk());
    }

    @Override
    public float go(float llx, float lly, float urx, float ury, float fixedLeading, float multipliedLeading, PdfTextAlignment alignment, TextDirection runDirection) {
        ColumnText colText = new ColumnText(this.pdfProducer.getPdfContentByte());
        colText.setSimpleColumn(this.phrase, llx, lly, urx, ury, fixedLeading, ClassicPdfUtils.toITextAlignment(alignment));
        if (multipliedLeading != 0.0f) {
            colText.setLeading(fixedLeading, multipliedLeading);
        }
        colText.setRunDirection(ClassicPhrase.toITextRunDirection(runDirection));
        try {
            colText.go();
        }
        catch (DocumentException e) {
            throw new JRRuntimeException(e);
        }
        return colText.getYLine();
    }

    protected static int toITextRunDirection(TextDirection direction) {
        int iTextDirection;
        switch (direction) {
            case DEFAULT: {
                iTextDirection = 0;
                break;
            }
            case LTR: {
                iTextDirection = 2;
                break;
            }
            case RTL: {
                iTextDirection = 3;
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown text direction " + (Object)((Object)direction));
            }
        }
        return iTextDirection;
    }
}

