/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import net.sf.jasperreports.engine.export.XmpWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfWriter;

public class PdfXmpCreator {
    private static final Log log = LogFactory.getLog(PdfXmpCreator.class);
    private static final String XMP_LIBARY_CLASS_NAME = "com.adobe.internal.xmp.XMPMetaFactory";
    private static final boolean XMP_LIBRARY = PdfXmpCreator.determineXmpLibrary();

    private static boolean determineXmpLibrary() {
        try {
            Class.forName(XMP_LIBARY_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            log.info((Object)"Adobe XMP library not found");
            return false;
        }
    }

    public static boolean supported() {
        return XMP_LIBRARY;
    }

    public static byte[] createXmpMetadata(PdfWriter pdfWriter) {
        XmpWriter writer = new XmpWriter(pdfWriter);
        return writer.createXmpMetadata();
    }
}

