/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.samplewrite;

import com.codahale.metrics.MetricRegistry;
import com.google.common.cache.CacheLoader;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.core.cache.Cache;
import org.opennms.core.cache.CacheBuilder;
import org.opennms.core.cache.CacheConfig;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.timeseries.TimeseriesStorageManager;
import org.opennms.netmgt.timeseries.samplewrite.MetaTagDataLoader;
import org.opennms.netmgt.timeseries.samplewrite.OffheapTimeSeriesWriter;
import org.opennms.netmgt.timeseries.samplewrite.RingBufferTimeseriesWriter;
import org.opennms.netmgt.timeseries.samplewrite.TimeseriesPersister;
import org.opennms.netmgt.timeseries.samplewrite.TimeseriesWriter;
import org.opennms.netmgt.timeseries.samplewrite.TimeseriesWriterConfig;
import org.opennms.netmgt.timeseries.stats.StatisticsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesPersisterFactory
implements PersisterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesPersisterFactory.class);
    private final TimeseriesWriter timeseriesWriter;
    private final MetaTagDataLoader metaTagDataLoader;
    private final Cache<ResourcePath, Set<Tag>> configuredAdditionalMetaTagCache;
    private final MetricRegistry registry;

    @Inject
    public TimeseriesPersisterFactory(MetaTagDataLoader metaTagDataLoader, StatisticsCollector stats, @Named(value="timeseriesStorageManager") TimeseriesStorageManager timeseriesStorageManager, @Named(value="timeseriesPersisterMetaTagCache") CacheConfig cacheConfig, @Named(value="timeseriesMetricRegistry") MetricRegistry registry, @Named(value="timeseriesWriterConfig") TimeseriesWriterConfig timeseriesWriterConfig) {
        this.timeseriesWriter = timeseriesWriterConfig.getBufferType() == TimeseriesWriterConfig.BufferType.OFFHEAP ? new OffheapTimeSeriesWriter(timeseriesStorageManager, timeseriesWriterConfig, registry) : new RingBufferTimeseriesWriter(timeseriesStorageManager, stats, timeseriesWriterConfig.getBufferSize(), timeseriesWriterConfig.getNumWriterThreads(), registry);
        LOG.info("Writer: {}", (Object)this.timeseriesWriter);
        this.metaTagDataLoader = metaTagDataLoader;
        this.configuredAdditionalMetaTagCache = new CacheBuilder().withConfig(cacheConfig).withCacheLoader((CacheLoader)metaTagDataLoader).build();
        this.registry = registry;
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository) {
        return this.createPersister(params, repository, false, false, false);
    }

    public Persister createPersister(ServiceParameters params, RrdRepository repository, boolean dontPersistCounters, boolean forceStoreByGroup, boolean dontReorderAttributes) {
        TimeseriesPersister persister = new TimeseriesPersister(params, repository, this.timeseriesWriter, this.metaTagDataLoader, this.configuredAdditionalMetaTagCache, this.registry);
        persister.setIgnorePersist(dontPersistCounters);
        return persister;
    }

    public void destroy() {
        if (this.timeseriesWriter != null) {
            this.timeseriesWriter.destroy();
        }
    }
}

