/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.sampleread;

import java.math.BigDecimal;
import org.opennms.core.sysprops.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LateAggregationParams {
    public static final long MIN_STEP_MS = SystemProperties.getLong((String)"org.opennms.timeseries.query.minimum_step", (Long)300000L);
    public static final int INTERVAL_DIVIDER = SystemProperties.getInteger((String)"org.opennms.timeseries.query.interval_divider", (int)2);
    public static final long DEFAULT_HEARTBEAT_MS = SystemProperties.getLong((String)"org.opennms.timeseries.query.heartbeat", (Long)450000L);
    public static final BigDecimal DEFAULT_HEARTBEAT_MULTIPLIER = SystemProperties.getBigDecimal((String)"org.opennms.timeseries.query.heartbeat.multiplier", (BigDecimal)new BigDecimal("1.5"));
    private static final Logger LOG = LoggerFactory.getLogger(LateAggregationParams.class);
    final long step;
    final long interval;
    final long heartbeat;

    private LateAggregationParams(long step, long interval, long heartbeat) {
        this.step = step;
        this.interval = interval;
        this.heartbeat = heartbeat;
    }

    public long getStep() {
        return this.step;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public static LateAggregationParamsBuilder builder() {
        return new LateAggregationParamsBuilder();
    }

    public static class LateAggregationParamsBuilder {
        private Long step;
        private Long interval;
        private Long heartbeat;

        public LateAggregationParamsBuilder step(Long step) {
            this.step = step;
            return this;
        }

        public LateAggregationParamsBuilder interval(Long interval) {
            this.interval = interval;
            return this;
        }

        public LateAggregationParamsBuilder heartbeat(Long heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public LateAggregationParams build() {
            long effectiveHeartbeat;
            long effectiveStep = Math.max(MIN_STEP_MS, this.step);
            if (effectiveStep != this.step) {
                LOG.warn("Requested step size {} is too small. Using {}.", (Object)this.step, (Object)effectiveStep);
            }
            long effectiveInterval = 0L;
            if (this.interval != null && this.interval < effectiveStep && effectiveStep % this.interval == 0L) {
                effectiveInterval = this.interval;
            } else {
                if (effectiveStep % (long)INTERVAL_DIVIDER != 0L) {
                    effectiveStep += effectiveStep % (long)INTERVAL_DIVIDER;
                }
                effectiveInterval = effectiveStep / (long)INTERVAL_DIVIDER;
            }
            long l = effectiveHeartbeat = this.heartbeat != null ? this.heartbeat : DEFAULT_HEARTBEAT_MS;
            if (effectiveHeartbeat < effectiveStep) {
                effectiveHeartbeat = DEFAULT_HEARTBEAT_MULTIPLIER.multiply(new BigDecimal(effectiveStep)).longValue();
            }
            if (effectiveInterval < effectiveHeartbeat) {
                if (effectiveHeartbeat % effectiveInterval != 0L) {
                    effectiveHeartbeat += effectiveInterval - effectiveHeartbeat % effectiveInterval;
                }
            } else {
                effectiveHeartbeat = effectiveInterval + 1L;
                effectiveHeartbeat += effectiveHeartbeat % effectiveInterval;
            }
            return new LateAggregationParams(effectiveStep, effectiveInterval, effectiveHeartbeat);
        }
    }
}

