/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.trapd.TrapDTO;

@XmlRootElement(name="trap-message-log")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TrapLogDTO
implements Message {
    @XmlAttribute(name="system-id", required=true)
    private String systemId;
    @XmlAttribute(name="location", required=true)
    private String location;
    @XmlAttribute(name="trap-address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress trapAddress;
    @XmlElement(name="messages")
    private List<TrapDTO> messages = new ArrayList<TrapDTO>();

    public TrapLogDTO() {
    }

    public TrapLogDTO(String systemId, String location, InetAddress trapAddress) {
        this.systemId = Objects.requireNonNull(systemId);
        this.location = Objects.requireNonNull(location);
        this.trapAddress = Objects.requireNonNull(trapAddress);
    }

    public List<TrapDTO> getMessages() {
        return this.messages;
    }

    public void addMessage(TrapDTO trapDTO) {
        this.messages.add(trapDTO);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public InetAddress getTrapAddress() {
        return this.trapAddress;
    }

    public void setTrapAddress(InetAddress trapAddress) {
        this.trapAddress = trapAddress;
    }

    public void setMessages(List<TrapDTO> messages) {
        this.messages = messages;
    }

    public int hashCode() {
        return Objects.hash(this.systemId, this.location, this.trapAddress, this.messages);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrapLogDTO other = (TrapLogDTO)obj;
        boolean equals = Objects.equals(this.location, other.location) && Objects.equals(this.systemId, other.systemId) && Objects.equals(this.trapAddress, other.trapAddress) && Objects.equals(this.messages, other.messages);
        return equals;
    }
}

