/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.security.auth;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.jradius.client.RadiusClient;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.security.JRadiusPrincipal;
import net.jradius.security.auth.JRadiusCallback;

public class JRadiusModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private String userName;
    private JRadiusPrincipal principal;
    private RadiusClient radiusClient;
    private AttributeList authAttributes;
    private AttributeList acctAttributes;
    private boolean debug = false;
    private boolean authenticated = false;
    private boolean committed = false;
    private int retries = 3;
    private int attempts = 0;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    public boolean commit() throws LoginException {
        if (!this.authenticated) {
            return false;
        }
        this.principal = new JRadiusPrincipal(this.userName);
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.attempts = 0;
        this.committed = true;
        return true;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler for this JRadius LoginModule.");
        }
        if (this.radiusClient == null) {
            try {
                this.radiusClient = new RadiusClient();
            }
            catch (Exception e) {
                throw new LoginException();
            }
        }
        NameCallback nameCallback = new NameCallback("User Name: ");
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", true);
        JRadiusCallback radiusCallback = new JRadiusCallback(this.radiusClient);
        Callback[] callbacks = new Callback[]{nameCallback, passwordCallback, radiusCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioex) {
            throw new LoginException(ioex.getMessage());
        }
        catch (UnsupportedCallbackException uscbex) {
            StringBuffer sb = new StringBuffer("Error: Callback ");
            sb.append(uscbex.getCallback().toString());
            sb.append(" not supported.");
            throw new LoginException(sb.toString());
        }
        this.userName = nameCallback.getName();
        String password = new String(passwordCallback.getPassword());
        try {
            RadiusResponse reply;
            AccessRequest request = new AccessRequest(this.radiusClient, radiusCallback.getAuthAttributes());
            request.addAttribute(AttributeFactory.newAttribute("User-Name", this.userName, "="));
            request.addAttribute(AttributeFactory.newAttribute("User-Password", password, "="));
            if (this.debug) {
                RadiusLog.debug("Sending:\n" + request.toString());
            }
            if ((reply = this.radiusClient.authenticate(request, radiusCallback.getRadiusAuthenticator(), this.retries)) == null) {
                throw new LoginException("no reply from remote RADIUS server");
            }
            if (this.debug) {
                RadiusLog.debug("Received:\n" + reply.toString());
            }
            if (!(reply instanceof AccessAccept)) {
                throw new CredentialExpiredException("authentication failed");
            }
        }
        catch (Exception ioex) {
            throw new LoginException(ioex.getMessage());
        }
        this.authenticated = true;
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.authenticated = false;
        this.committed = false;
        this.userName = null;
        this.principal = null;
        this.attempts = 0;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.authenticated) {
            return false;
        }
        if (this.authenticated && !this.committed) {
            this.authenticated = false;
            this.attempts = 0;
        } else {
            this.logout();
        }
        return true;
    }
}

