/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.io.IOException;
import java.net.DatagramPacket;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import net.jradius.client.RadiusClient;
import net.jradius.exception.RadiusException;
import net.jradius.freeradius.FreeRadiusFormat;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessChallenge;
import net.jradius.packet.AccessReject;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.AccountingResponse;
import net.jradius.packet.AccountingStatus;
import net.jradius.packet.CoAACK;
import net.jradius.packet.CoANAK;
import net.jradius.packet.CoARequest;
import net.jradius.packet.DHCPAck;
import net.jradius.packet.DHCPDecline;
import net.jradius.packet.DHCPDiscover;
import net.jradius.packet.DHCPForceRenew;
import net.jradius.packet.DHCPInform;
import net.jradius.packet.DHCPNack;
import net.jradius.packet.DHCPOffer;
import net.jradius.packet.DHCPRelease;
import net.jradius.packet.DHCPRequest;
import net.jradius.packet.DisconnectACK;
import net.jradius.packet.DisconnectNAK;
import net.jradius.packet.DisconnectRequest;
import net.jradius.packet.Format;
import net.jradius.packet.NullPacket;
import net.jradius.packet.PasswordAck;
import net.jradius.packet.PasswordReject;
import net.jradius.packet.PasswordRequest;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.attribute.AttributeList;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class PacketFactory {
    private static LinkedHashMap<Integer, Class<?>> codeMap = new LinkedHashMap();
    private static KeyedObjectPool pktObjectPool;

    private static RadiusPacket createPacket(Integer code) throws Exception {
        Class<?> c = codeMap.get(code);
        if (c == null) {
            throw new RadiusException("bad radius code " + code);
        }
        RadiusPacket p = (RadiusPacket)c.newInstance();
        return p;
    }

    public static RadiusPacket newPacket(Integer code, boolean pool) {
        try {
            if (pool && pktObjectPool != null) {
                RadiusPacket p = (RadiusPacket)pktObjectPool.borrowObject((Object)code);
                return p;
            }
            return PacketFactory.createPacket(code);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static RadiusPacket newPacket(Integer code) {
        return PacketFactory.newPacket(code, true);
    }

    public static RadiusPacket newPacket(byte b) {
        return PacketFactory.newPacket(new Integer(b));
    }

    public static RadiusPacket newPacket(byte b, int identifier) {
        RadiusPacket p = PacketFactory.newPacket(new Integer(b));
        p.setIdentifier(identifier);
        return p;
    }

    public static RadiusPacket newPacket(byte b, int identifier, AttributeList list) {
        RadiusPacket p = PacketFactory.newPacket(new Integer(b));
        p.setIdentifier(identifier);
        p.getAttributes().add(list);
        return p;
    }

    public static RadiusPacket newPacket(byte b, AttributeList list) {
        RadiusPacket p = PacketFactory.newPacket(new Integer(b));
        p.getAttributes().add(list);
        return p;
    }

    public static RadiusRequest newPacket(byte b, RadiusClient client, AttributeList list) {
        RadiusRequest p = (RadiusRequest)PacketFactory.newPacket(new Integer(b));
        p.setRadiusClient(client);
        p.getAttributes().add(list);
        return p;
    }

    public static RadiusPacket copyPacket(RadiusPacket req, boolean pool) {
        RadiusPacket p = PacketFactory.newPacket(req.code, pool);
        p.setIdentifier(req.getIdentifier());
        p.setAuthenticator(req.getAuthenticator());
        p.getAttributes().copy(req.getAttributes(), pool);
        return p;
    }

    public static RadiusPacket parse(DatagramPacket dp, boolean pool) throws RadiusException {
        ByteBuffer buffer = ByteBuffer.wrap(dp.getData(), dp.getOffset(), dp.getLength());
        RadiusPacket rp = null;
        try {
            rp = PacketFactory.parseUDP(buffer, pool);
        }
        catch (IOException e) {
            RadiusLog.error(e.getMessage(), e);
        }
        return rp;
    }

    public static RadiusPacket parseUDP(ByteBuffer buffer, boolean pool) throws RadiusException, IOException {
        short code = RadiusFormat.getUnsignedByte(buffer);
        short identifier = RadiusFormat.getUnsignedByte(buffer);
        int length = RadiusFormat.getUnsignedShort(buffer);
        return PacketFactory.parseUDP(code, identifier, length, buffer, pool);
    }

    public static RadiusPacket parseUDP(int code, int identifier, int length, ByteBuffer buffer, boolean pool) throws RadiusException, IOException {
        RadiusPacket rp = null;
        Integer key = new Integer(code);
        if (pktObjectPool != null && pool) {
            try {
                rp = (RadiusPacket)pktObjectPool.borrowObject((Object)key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (rp == null) {
            Class<?> c = codeMap.get(key);
            if (c == null) {
                throw new RadiusException("bad radius code - " + key);
            }
            try {
                rp = (RadiusPacket)c.newInstance();
            }
            catch (Exception e) {
                RadiusLog.error(e.getMessage(), e);
                return null;
            }
        }
        byte[] bAuthenticator = new byte[16];
        buffer.get(bAuthenticator);
        rp.setIdentifier(identifier);
        rp.setAuthenticator(bAuthenticator);
        if ((length -= 20) > 0) {
            RadiusFormat.setAttributeBytes(rp, buffer, length);
        }
        return rp;
    }

    public static RadiusPacket parsePacket(ByteBuffer buffer) throws RadiusException {
        RadiusPacket rp = null;
        int code = (int)Format.getUnsignedInt(buffer);
        int identifier = (int)Format.getUnsignedInt(buffer);
        long length = Format.getUnsignedInt(buffer);
        Integer key = new Integer(code);
        if (pktObjectPool != null) {
            try {
                rp = (RadiusPacket)pktObjectPool.borrowObject((Object)key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (rp == null) {
            Class<?> c = codeMap.get(key);
            if (c == null) {
                throw new RadiusException("bad radius packet type: " + code);
            }
            try {
                rp = (RadiusPacket)c.newInstance();
            }
            catch (Exception e) {
                RadiusLog.error(e.getMessage(), e);
            }
        }
        try {
            rp.setIdentifier(identifier);
            FreeRadiusFormat.setAttributeBytes(rp, buffer, (int)length);
        }
        catch (Exception e) {
            RadiusLog.error(e.getMessage(), e);
        }
        return rp;
    }

    public static RadiusPacket[] parse(ByteBuffer buffer, int packetCount) {
        RadiusPacket[] rp = new RadiusPacket[packetCount];
        try {
            for (int i = 0; i < packetCount; ++i) {
                rp[i] = PacketFactory.parsePacket(buffer);
            }
        }
        catch (RadiusException e) {
            RadiusLog.error(e.getMessage(), e);
        }
        return rp;
    }

    public static void poolStatus() {
        if (pktObjectPool == null) {
            return;
        }
        System.err.println("PacketPool: " + PacketFactory.getPoolStatus());
    }

    public static String getPoolStatus() {
        if (pktObjectPool == null) {
            return "";
        }
        return "active=" + pktObjectPool.getNumActive() + ", idle=" + pktObjectPool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(RadiusPacket p) {
        RadiusPacket radiusPacket = p;
        synchronized (radiusPacket) {
            AttributeList list = p.getAttributes();
            list.clear();
            if (pktObjectPool != null && p.recyclable) {
                try {
                    pktObjectPool.returnObject((Object)new Integer(p.getCode()), (Object)p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void recycle(RadiusPacket[] rp) {
        if (rp != null) {
            for (int i = 0; i < rp.length; ++i) {
                if (rp[i] == null) continue;
                PacketFactory.recycle(rp[i]);
            }
        }
    }

    static {
        codeMap.put(new Integer(0), NullPacket.class);
        codeMap.put(new Integer(1), AccessRequest.class);
        codeMap.put(new Integer(2), AccessAccept.class);
        codeMap.put(new Integer(3), AccessReject.class);
        codeMap.put(new Integer(4), AccountingRequest.class);
        codeMap.put(new Integer(5), AccountingResponse.class);
        codeMap.put(new Integer(6), AccountingStatus.class);
        codeMap.put(new Integer(7), PasswordRequest.class);
        codeMap.put(new Integer(8), PasswordAck.class);
        codeMap.put(new Integer(9), PasswordReject.class);
        codeMap.put(new Integer(11), AccessChallenge.class);
        codeMap.put(new Integer(40), DisconnectRequest.class);
        codeMap.put(new Integer(41), DisconnectACK.class);
        codeMap.put(new Integer(42), DisconnectNAK.class);
        codeMap.put(new Integer(43), CoARequest.class);
        codeMap.put(new Integer(44), CoAACK.class);
        codeMap.put(new Integer(45), CoANAK.class);
        codeMap.put(new Integer(1025), DHCPDiscover.class);
        codeMap.put(new Integer(1026), DHCPOffer.class);
        codeMap.put(new Integer(1027), DHCPRequest.class);
        codeMap.put(new Integer(1028), DHCPDecline.class);
        codeMap.put(new Integer(1029), DHCPAck.class);
        codeMap.put(new Integer(1030), DHCPNack.class);
        codeMap.put(new Integer(1031), DHCPRelease.class);
        codeMap.put(new Integer(1032), DHCPInform.class);
        codeMap.put(new Integer(1033), DHCPForceRenew.class);
        pktObjectPool = new PacketFactoryPool();
    }

    public static class PacketFactoryPool
    extends GenericKeyedObjectPool {
        public PacketFactoryPool() {
            super(new KeyedPoolableObjectFactory(){

                public boolean validateObject(Object arg0, Object arg1) {
                    return true;
                }

                public void passivateObject(Object arg0, Object arg1) throws Exception {
                    RadiusPacket p = (RadiusPacket)arg1;
                    p.recycled = true;
                }

                public Object makeObject(Object arg0) throws Exception {
                    RadiusPacket p = PacketFactory.createPacket((Integer)arg0);
                    p.recyclable = true;
                    p.recycled = false;
                    return p;
                }

                public void destroyObject(Object arg0, Object arg1) throws Exception {
                }

                public void activateObject(Object arg0, Object arg1) throws Exception {
                    RadiusPacket p = (RadiusPacket)arg1;
                    p.setAuthenticator(null);
                    p.recycled = false;
                }
            });
            this.setMaxActive(-1);
            this.setMaxIdle(-1);
        }
    }
}

