/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.server.impl.net.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.server.SyslogServerEventIF;
import org.graylog2.syslog4j.server.SyslogServerIF;
import org.graylog2.syslog4j.server.impl.AbstractSyslogServer;
import org.graylog2.syslog4j.server.impl.net.udp.UDPNetSyslogServerConfig;
import org.graylog2.syslog4j.util.SyslogUtility;

public class UDPNetSyslogServer
extends AbstractSyslogServer {
    protected DatagramSocket ds = null;

    @Override
    public void initialize() throws SyslogRuntimeException {
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.syslogServerConfig.getShutdownWait() > 0L) {
            SyslogUtility.sleep(this.syslogServerConfig.getShutdownWait());
        }
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
    }

    protected DatagramSocket createDatagramSocket() throws SocketException, UnknownHostException {
        DatagramSocket datagramSocket = null;
        if (this.syslogServerConfig.getHost() != null) {
            InetAddress inetAddress = InetAddress.getByName(this.syslogServerConfig.getHost());
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort(), inetAddress);
        } else {
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort());
        }
        return datagramSocket;
    }

    @Override
    public void run() {
        try {
            this.ds = this.createDatagramSocket();
            this.shutdown = false;
        }
        catch (SocketException se) {
            return;
        }
        catch (UnknownHostException uhe) {
            return;
        }
        byte[] receiveData = new byte[this.syslogBufferSize()];
        UDPNetSyslogServer.handleInitialize(this);
        while (!this.shutdown) {
            DatagramPacket dp = null;
            try {
                dp = new DatagramPacket(receiveData, receiveData.length);
                this.ds.receive(dp);
                if (dp.getLength() <= 0) continue;
                SyslogServerEventIF event = UDPNetSyslogServer.createEvent(this.getConfig(), receiveData, dp.getLength(), dp.getAddress());
                UDPNetSyslogServer.handleEvent(null, (SyslogServerIF)this, dp, event);
            }
            catch (SocketException se) {
                int i = se.getMessage() == null ? -1 : se.getMessage().toLowerCase().indexOf("socket closed");
                if (i != -1) continue;
                UDPNetSyslogServer.handleException(null, this, dp.getSocketAddress(), se);
            }
            catch (IOException ioe) {
                UDPNetSyslogServer.handleException(null, this, dp.getSocketAddress(), ioe);
            }
        }
        UDPNetSyslogServer.handleDestroy(this);
    }

    private int syslogBufferSize() {
        if (this.getConfig() instanceof UDPNetSyslogServerConfig) {
            return ((UDPNetSyslogServerConfig)this.getConfig()).getMaxMessageSize();
        }
        return 1024;
    }
}

