/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionAware;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.CollapsibleRef;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdTopologyFactory;
import org.slf4j.LoggerFactory;

public class LinkdSelectionAware
implements SelectionAware {
    private final LinkdTopologyFactory m_linkdTopologyFactory;

    public LinkdSelectionAware(LinkdTopologyFactory factory) {
        this.m_linkdTopologyFactory = factory;
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        List<Integer> nodeIds = this.extractNodeIds(selectedVertices);
        if (type == ContentType.Alarm) {
            return new SelectionChangedListener.AlarmNodeIdSelection(nodeIds);
        }
        if (type == ContentType.Node) {
            return new SelectionChangedListener.IdSelection(nodeIds);
        }
        return SelectionChangedListener.Selection.NONE;
    }

    public boolean contributesTo(ContentType type) {
        return Sets.newHashSet((Object[])new ContentType[]{ContentType.Alarm, ContentType.Node}).contains(type);
    }

    protected List<Integer> extractNodeIds(Collection<VertexRef> vertices) {
        ArrayList<Integer> nodeIdList = new ArrayList<Integer>();
        for (VertexRef eachRef : vertices) {
            if (this.m_linkdTopologyFactory.getActiveNamespace().startsWith(eachRef.getNamespace())) {
                try {
                    nodeIdList.add(Integer.valueOf(eachRef.getId()));
                }
                catch (NumberFormatException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Cannot filter nodes with ID: {}", (Object)eachRef.getId());
                }
                continue;
            }
            if (!"category".equals(eachRef.getNamespace()) || !(eachRef instanceof CollapsibleRef)) continue;
            CollapsibleRef collapsible = (CollapsibleRef)eachRef;
            nodeIdList.addAll(Collections2.transform((Collection)collapsible.getChildren(), input -> Integer.valueOf(input.getId())));
        }
        return nodeIdList;
    }
}

