/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import com.google.common.base.MoreObjects;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonBackReference;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;

@Entity
@Table(name="applications")
@XmlRootElement(name="application")
public class OnmsApplication
implements Comparable<OnmsApplication> {
    private Integer id;
    private String name;
    private Set<OnmsMonitoredService> monitoredServices = new LinkedHashSet<OnmsMonitoredService>();
    private Set<OnmsMonitoringLocation> perspectiveLocations = new LinkedHashSet<OnmsMonitoringLocation>();

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    @XmlAttribute
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="name", length=32, nullable=false, unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToMany(mappedBy="applications", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @XmlIDREF
    @XmlElement(name="monitoredServiceId")
    @XmlElementWrapper(name="monitoredServices")
    @JsonBackReference
    public Set<OnmsMonitoredService> getMonitoredServices() {
        return this.monitoredServices;
    }

    public void setMonitoredServices(Set<OnmsMonitoredService> services) {
        this.monitoredServices = services;
    }

    public void addMonitoredService(OnmsMonitoredService service) {
        this.getMonitoredServices().add(service);
    }

    public void removeMonitoredService(OnmsMonitoredService service) {
        this.getMonitoredServices().remove(service);
    }

    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="application_perspective_location_map", joinColumns={@JoinColumn(name="appid", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="monitoringlocationid", referencedColumnName="id")})
    @XmlIDREF
    @XmlElement(name="perspectiveLocationId")
    @XmlElementWrapper(name="perspectiveLocations")
    public Set<OnmsMonitoringLocation> getPerspectiveLocations() {
        return this.perspectiveLocations;
    }

    public void setPerspectiveLocations(Set<OnmsMonitoringLocation> perspectiveLocations) {
        this.perspectiveLocations = perspectiveLocations;
    }

    public void addPerspectiveLocation(OnmsMonitoringLocation perspectiveLocation) {
        this.getPerspectiveLocations().add(perspectiveLocation);
    }

    @Override
    public int compareTo(OnmsApplication o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OnmsApplication) {
            OnmsApplication app = (OnmsApplication)obj;
            return this.getName().equals(app.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

