/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vacuumd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.vacuumd.Action;
import org.opennms.netmgt.config.vacuumd.ActionEvent;
import org.opennms.netmgt.config.vacuumd.AutoEvent;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Statement;
import org.opennms.netmgt.config.vacuumd.Trigger;

@XmlRootElement(name="VacuumdConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="vacuumd-configuration.xsd")
public class VacuumdConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="period", required=true)
    private Integer m_period;
    @XmlElement(name="statement")
    private List<Statement> m_statements = new ArrayList<Statement>();
    @XmlElementWrapper(name="automations")
    @XmlElement(name="automation")
    private List<Automation> m_automations = new ArrayList<Automation>();
    @XmlElementWrapper(name="triggers")
    @XmlElement(name="trigger")
    private List<Trigger> m_triggers = new ArrayList<Trigger>();
    @XmlElementWrapper(name="actions")
    @XmlElement(name="action")
    private List<Action> m_actions = new ArrayList<Action>();
    @XmlElementWrapper(name="auto-events")
    @XmlElement(name="auto-event")
    private List<AutoEvent> m_autoEvents = new ArrayList<AutoEvent>();
    @XmlElementWrapper(name="action-events")
    @XmlElement(name="action-event")
    private List<ActionEvent> m_actionEvents = new ArrayList<ActionEvent>();

    public VacuumdConfiguration() {
    }

    public VacuumdConfiguration(Integer period, List<Statement> statements, List<Automation> automations, List<Trigger> triggers, List<Action> actions, List<AutoEvent> autoEvents, List<ActionEvent> actionEvents) {
        this.setPeriod(period);
        this.setStatements(statements);
        this.setAutomations(automations);
        this.setTriggers(triggers);
        this.setActions(actions);
        this.setAutoEvents(autoEvents);
        this.setActionEvents(actionEvents);
    }

    public Integer getPeriod() {
        return this.m_period == null ? 0 : this.m_period;
    }

    public void setPeriod(Integer period) {
        this.m_period = ConfigUtils.assertNotNull(period, "period");
    }

    public List<Statement> getStatements() {
        return this.m_statements;
    }

    public void setStatements(List<Statement> statements) {
        if (statements == this.m_statements) {
            return;
        }
        this.m_statements.clear();
        if (statements != null) {
            this.m_statements.addAll(statements);
        }
    }

    public void addStatement(Statement statement) {
        this.m_statements.add(statement);
    }

    public boolean removeStatement(Statement statement) {
        return this.m_statements.remove(statement);
    }

    public List<Automation> getAutomations() {
        return this.m_automations;
    }

    public void setAutomations(List<Automation> automations) {
        if (automations == this.m_automations) {
            return;
        }
        this.m_automations.clear();
        if (automations != null) {
            this.m_automations.addAll(automations);
        }
    }

    public void addAutomation(Automation automation) {
        this.m_automations.add(automation);
    }

    public boolean removeAutomation(Automation automation) {
        return this.m_automations.remove(automation);
    }

    public List<Trigger> getTriggers() {
        return this.m_triggers;
    }

    public void setTriggers(List<Trigger> triggers) {
        if (triggers == this.m_triggers) {
            return;
        }
        this.m_triggers.clear();
        if (triggers != null) {
            this.m_triggers.addAll(triggers);
        }
    }

    public void addTrigger(Trigger trigger) {
        this.m_triggers.add(trigger);
    }

    public boolean removeTrigger(Trigger trigger) {
        return this.m_triggers.remove(trigger);
    }

    public List<Action> getActions() {
        return this.m_actions;
    }

    public void setActions(List<Action> actions) {
        if (actions == this.m_actions) {
            return;
        }
        this.m_actions.clear();
        if (actions != null) {
            this.m_actions.addAll(actions);
        }
    }

    public void addAction(Action action) {
        this.m_actions.add(action);
    }

    public boolean removeAction(Action action) {
        return this.m_actions.remove(action);
    }

    public List<AutoEvent> getAutoEvents() {
        return this.m_autoEvents;
    }

    public void setAutoEvents(List<AutoEvent> autoEvents) {
        if (autoEvents == this.m_autoEvents) {
            return;
        }
        this.m_autoEvents.clear();
        if (autoEvents != null) {
            this.m_autoEvents.addAll(autoEvents);
        }
    }

    public void addAutoEvent(AutoEvent autoEvent) {
        this.m_autoEvents.add(autoEvent);
    }

    public boolean removeAutoEvent(AutoEvent autoEvent) {
        return this.m_autoEvents.remove(autoEvent);
    }

    public List<ActionEvent> getActionEvents() {
        return this.m_actionEvents;
    }

    public void setActionEvents(List<ActionEvent> actionEvents) {
        if (actionEvents == this.m_actionEvents) {
            return;
        }
        this.m_actionEvents.clear();
        if (actionEvents != null) {
            this.m_actionEvents.addAll(actionEvents);
        }
    }

    public void addActionEvent(ActionEvent actionEvent) {
        this.m_actionEvents.add(actionEvent);
    }

    public boolean removeActionEvent(ActionEvent actionEvent) {
        return this.m_actionEvents.remove(actionEvent);
    }

    public int hashCode() {
        return Objects.hash(this.m_period, this.m_statements, this.m_automations, this.m_triggers, this.m_actions, this.m_autoEvents, this.m_actionEvents);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VacuumdConfiguration) {
            VacuumdConfiguration that = (VacuumdConfiguration)obj;
            return Objects.equals(this.m_period, that.m_period) && Objects.equals(this.m_statements, that.m_statements) && Objects.equals(this.m_automations, that.m_automations) && Objects.equals(this.m_triggers, that.m_triggers) && Objects.equals(this.m_actions, that.m_actions) && Objects.equals(this.m_autoEvents, that.m_autoEvents) && Objects.equals(this.m_actionEvents, that.m_actionEvents);
        }
        return false;
    }
}

