/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.syslogd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.syslogd.Configuration;
import org.opennms.netmgt.config.syslogd.HideMatch;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="syslogd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="syslog.xsd")
public class SyslogdConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="configuration", required=true)
    private Configuration m_configuration;
    @XmlElementWrapper(name="ueiList", required=false)
    @XmlElement(name="ueiMatch")
    private List<UeiMatch> m_ueiMatches = new ArrayList<UeiMatch>();
    @XmlElementWrapper(name="hideMessage", required=false)
    @XmlElement(name="hideMatch")
    private List<HideMatch> m_hideMatches = new ArrayList<HideMatch>();
    @XmlElement(name="import-file")
    private List<String> m_importFiles = new ArrayList<String>();

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.m_configuration = ConfigUtils.assertNotNull(configuration, "configuration");
    }

    public List<UeiMatch> getUeiMatches() {
        return this.m_ueiMatches;
    }

    public void setUeiMatches(List<UeiMatch> ueiMatches) {
        if (ueiMatches == this.m_ueiMatches) {
            return;
        }
        this.m_ueiMatches.clear();
        if (ueiMatches != null) {
            this.m_ueiMatches.addAll(ueiMatches);
        }
    }

    public void addUeiMatch(UeiMatch ueiMatch) {
        this.m_ueiMatches.add(ueiMatch);
    }

    public boolean removeUeiMatch(UeiMatch ueiMatch) {
        return this.m_ueiMatches.remove(ueiMatch);
    }

    public List<HideMatch> getHideMatches() {
        return this.m_hideMatches;
    }

    public void setHideMatches(List<HideMatch> hideMatches) {
        if (hideMatches == this.m_hideMatches) {
            return;
        }
        this.m_hideMatches.clear();
        if (hideMatches != null) {
            this.m_hideMatches.addAll(hideMatches);
        }
    }

    public void addHideMatch(HideMatch hideMatch) {
        this.m_hideMatches.add(hideMatch);
    }

    public boolean removeHideMatch(HideMatch hideMatch) {
        return this.m_hideMatches.remove(hideMatch);
    }

    public List<String> getImportFiles() {
        return this.m_importFiles;
    }

    public void setImportFiles(List<String> importFiles) {
        if (importFiles == null) {
            return;
        }
        this.m_importFiles.clear();
        if (importFiles != null) {
            this.m_importFiles.addAll(importFiles);
        }
    }

    public void addImportFile(String importFile) {
        this.m_importFiles.add(importFile);
    }

    public boolean removeImportFile(String importFile) {
        return this.m_importFiles.remove(importFile);
    }

    public int hashCode() {
        return Objects.hash(this.m_configuration, this.m_ueiMatches, this.m_hideMatches, this.m_importFiles);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SyslogdConfiguration) {
            SyslogdConfiguration that = (SyslogdConfiguration)obj;
            return Objects.equals(this.m_configuration, that.m_configuration) && Objects.equals(this.m_ueiMatches, that.m_ueiMatches) && Objects.equals(this.m_hideMatches, that.m_hideMatches) && Objects.equals(this.m_importFiles, that.m_importFiles);
        }
        return false;
    }
}

