/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.reportd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.config.reportd.StupidBooleanAdapter;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="reportd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="reportd-configuration.xsd")
public class ReportdConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="storage-location", required=true)
    private String m_storageLocation;
    @XmlAttribute(name="persist-reports", required=true)
    @XmlJavaTypeAdapter(value=StupidBooleanAdapter.class)
    private Boolean m_persistReports;
    @XmlElement(name="report")
    private List<Report> m_reports = new ArrayList<Report>();

    public void addReport(Report report) {
        this.m_reports.add(report);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReportdConfiguration) {
            ReportdConfiguration that = (ReportdConfiguration)obj;
            return Objects.equals(this.m_storageLocation, that.m_storageLocation) && Objects.equals(this.m_persistReports, that.m_persistReports) && Objects.equals(this.m_reports, that.m_reports);
        }
        return false;
    }

    public Boolean getPersistReports() {
        return this.m_persistReports;
    }

    public List<Report> getReports() {
        return this.m_reports;
    }

    public String getStorageLocation() {
        return this.m_storageLocation;
    }

    public int hashCode() {
        return Objects.hash(this.m_storageLocation, this.m_persistReports, this.m_reports);
    }

    public boolean removeReport(Report report) {
        return this.m_reports.remove(report);
    }

    public void setPersistReports(Boolean persistReports) {
        this.m_persistReports = ConfigUtils.assertNotNull(persistReports, "persist-reports");
    }

    public void setReport(List<Report> reports) {
        if (reports == this.m_reports) {
            return;
        }
        this.m_reports.clear();
        if (reports != null) {
            this.m_reports.addAll(reports);
        }
    }

    public void setStorageLocation(String storageLocation) {
        this.m_storageLocation = ConfigUtils.assertNotEmpty(storageLocation, "storage-location");
    }
}

