/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.provisiond;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.config.utils.ConfigUtils;

public class RequisitionDef
implements Serializable {
    private static final List<String> RESCAN_EXISTING_OPTIONS = Arrays.asList("true", "false", "dbonly");
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_RESCAN_EXISTING = System.getProperty("org.opennms.provisiond.scheduleRescanForUpdatedNodes", "true");
    private String importUrlResource;
    private String importName;
    private String rescanExisting;
    private String cronSchedule;

    public Optional<String> getImportUrlResource() {
        return Optional.ofNullable(this.importUrlResource);
    }

    public void setImportUrlResource(String importUrlResource) {
        this.importUrlResource = ConfigUtils.assertNotEmpty(importUrlResource, "import-url-resource");
    }

    public Optional<String> getImportName() {
        return Optional.ofNullable(this.importName);
    }

    public void setImportName(String importName) {
        this.importName = ConfigUtils.assertNotEmpty(importName, "import-name");
    }

    public String getRescanExisting() {
        return this.rescanExisting != null ? this.rescanExisting : DEFAULT_RESCAN_EXISTING;
    }

    public void setRescanExisting(String rescanExisting) {
        this.rescanExisting = ConfigUtils.assertOnlyContains(ConfigUtils.normalizeString(rescanExisting), RESCAN_EXISTING_OPTIONS, "rescan-existing");
    }

    public Optional<String> getCronSchedule() {
        return Optional.ofNullable(this.cronSchedule);
    }

    public void setCronSchedule(String cronSchedule) {
        this.cronSchedule = ConfigUtils.assertNotEmpty(cronSchedule, "cron-schedule");
    }

    public int hashCode() {
        return Objects.hash(this.importUrlResource, this.importName, this.rescanExisting, this.cronSchedule);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RequisitionDef) {
            RequisitionDef that = (RequisitionDef)obj;
            return Objects.equals(this.importUrlResource, that.importUrlResource) && Objects.equals(this.importName, that.importName) && Objects.equals(this.rescanExisting, that.rescanExisting) && Objects.equals(this.cronSchedule, that.cronSchedule);
        }
        return false;
    }
}

