/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.agents;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.xml.JaxbMapAdapter;

@XmlRootElement(name="agent")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AgentResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress m_address;
    @XmlElement(name="port")
    private Integer m_port;
    @XmlElement(name="serviceName")
    private String m_serviceName;
    @XmlElement(name="parameters")
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    private Map<String, String> m_parameters = new HashMap<String, String>();

    public AgentResponse() {
    }

    public AgentResponse(InetAddress address, Integer port, String serviceName, Map<String, String> parameters) {
        this.m_address = address;
        this.m_port = port;
        this.m_serviceName = serviceName;
        this.m_parameters = parameters;
    }

    public Optional<InetAddress> getAddress() {
        return Optional.ofNullable(this.m_address);
    }

    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.m_port);
    }

    public Optional<String> getServiceName() {
        return Optional.ofNullable(this.m_serviceName);
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public String toString() {
        return "AgentResponse [address=" + this.m_address + ", port=" + this.m_port + ", serviceName=" + this.m_serviceName + ", parameters=" + this.m_parameters + "]";
    }

    public int hashCode() {
        return Objects.hash(this.m_address, this.m_port, this.m_serviceName, this.m_parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AgentResponse) {
            AgentResponse that = (AgentResponse)obj;
            return Objects.equals(this.m_address, that.m_address) && Objects.equals(this.m_port, that.m_port) && Objects.equals(this.m_serviceName, that.m_serviceName) && Objects.equals(this.m_parameters, that.m_parameters);
        }
        return false;
    }
}

