/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.thresholding.impl;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.network.IpListFromUrl;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.dao.thresholding.api.ReadableThreshdDao;
import org.opennms.netmgt.config.threshd.ExcludeRange;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.ThreshdConfiguration;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThreshdDao
implements ReadableThreshdDao {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractThreshdDao.class);
    public static final String JSON_STORE_KEY = "threshd-configuration";
    private IPMap ipMap;
    final JsonStore jsonStore;

    AbstractThreshdDao() {
        this.jsonStore = null;
        this.reload();
    }

    AbstractThreshdDao(JsonStore jsonStore) {
        this.jsonStore = Objects.requireNonNull(jsonStore);
    }

    public void reload() {
        this.ipMap = new IPMap();
    }

    public final void rebuildPackageIpListMap() {
        this.ipMap.rebuildPackageIpListMap();
    }

    public final boolean interfaceInPackage(String iface, Package pkg) {
        return this.ipMap.interfaceInPackage(iface, pkg);
    }

    private class IPMap {
        private final Map<String, List<String>> urlIPMap = new HashMap<String, List<String>>();
        private final Map<Package, List<InetAddress>> pkgIpMap = new HashMap<Package, List<InetAddress>>();

        private IPMap() {
            this.createUrlIpMap();
            this.createPackageIpListMap();
        }

        private synchronized void createUrlIpMap() {
            for (Package pkg : ((ThreshdConfiguration)AbstractThreshdDao.this.getReadOnlyConfig()).getPackages()) {
                for (String urlname : pkg.getIncludeUrls()) {
                    List iplist = IpListFromUrl.fetch((String)urlname);
                    if (iplist.size() <= 0) continue;
                    this.urlIPMap.put(urlname, iplist);
                }
            }
        }

        private synchronized void createPackageIpListMap() {
            for (Package pkg : ((ThreshdConfiguration)AbstractThreshdDao.this.getReadOnlyConfig()).getPackages()) {
                StringBuilder filterRules = new StringBuilder();
                if (pkg.getFilter().getContent().isPresent()) {
                    filterRules.append((String)pkg.getFilter().getContent().get());
                }
                try {
                    LOG.debug("createPackageIpMap: package is {}. filer rules are {}", (Object)filterRules, (Object)pkg.getName());
                    FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
                    List ipList = FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules.toString());
                    if (ipList.size() <= 0) continue;
                    this.pkgIpMap.put(pkg, ipList);
                }
                catch (Throwable t) {
                    LOG.error("createPackageIpMap: failed to map package: {} to an IP List with filter \"{}\"", new Object[]{pkg.getName(), pkg.getFilter().getContent().orElse(null), t});
                }
            }
        }

        private synchronized boolean interfaceInUrl(String addr, String url) {
            boolean bRet = false;
            List<String> iplist = this.urlIPMap.get(url);
            if (iplist != null && iplist.size() > 0) {
                bRet = iplist.contains(addr);
            }
            return bRet;
        }

        private synchronized boolean interfaceInPackage(String iface, Package pkg) {
            InetAddress ifaceAddr = InetAddressUtils.addr((String)iface);
            boolean filterPassed = false;
            List<InetAddress> ipList = this.pkgIpMap.get(pkg);
            if (ipList != null && ipList.size() > 0) {
                filterPassed = ipList.contains(ifaceAddr);
            }
            LOG.debug("interfaceInPackage: Interface {} passed filter for package {}?: {}", new Object[]{filterPassed, iface, pkg.getName()});
            if (!filterPassed) {
                return false;
            }
            boolean has_specific = false;
            boolean has_range_include = false;
            boolean has_range_exclude = false;
            has_range_include = pkg.getIncludeRanges().size() == 0 && pkg.getSpecifics().size() == 0;
            for (Object rng : pkg.getIncludeRanges()) {
                if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
                has_range_include = true;
                break;
            }
            byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
            for (String spec : pkg.getSpecifics()) {
                byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
                if (new ByteArrayComparator().compare(speca, addr) != 0) continue;
                has_specific = true;
                break;
            }
            Iterator eurl = pkg.getIncludeUrls().iterator();
            while (!has_specific && eurl.hasNext()) {
                has_specific = this.interfaceInUrl(iface, (String)eurl.next());
            }
            for (ExcludeRange rng : pkg.getExcludeRanges()) {
                if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
                has_range_exclude = true;
                break;
            }
            return has_specific || has_range_include && !has_range_exclude;
        }

        private synchronized void rebuildPackageIpListMap() {
            this.pkgIpMap.clear();
            this.createPackageIpListMap();
        }
    }
}

