/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.state;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.state.OptionState;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.state.TemplateState;

public class ExporterState {
    public final String key;
    public final List<TemplateState> templates;
    public final List<OptionState> options;

    public ExporterState(Builder builder) {
        this.key = Objects.requireNonNull(builder.key);
        this.templates = (List)Objects.requireNonNull(builder.templates.build());
        this.options = (List)Objects.requireNonNull(builder.options.build());
    }

    public static Builder builder(String sessionKey) {
        return new Builder(sessionKey);
    }

    public static class Builder {
        private final String key;
        private final ImmutableList.Builder<TemplateState> templates = ImmutableList.builder();
        private final ImmutableList.Builder<OptionState> options = ImmutableList.builder();

        private Builder(String key) {
            this.key = Objects.requireNonNull(key);
        }

        public Builder withTemplate(TemplateState state) {
            this.templates.add((Object)state);
            return this;
        }

        public Builder withTemplate(TemplateState.Builder state) {
            return this.withTemplate(state.build());
        }

        public Builder withOptions(OptionState state) {
            this.options.add((Object)state);
            return this;
        }

        public Builder withOptions(OptionState.Builder state) {
            return this.withOptions(state.build());
        }

        public ExporterState build() {
            return new ExporterState(this);
        }
    }
}

