/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.endpoints.grafana.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.opennms.netmgt.endpoints.grafana.api.Panel;

public class PanelDeserializer
implements JsonDeserializer<Panel> {
    private Gson gson;

    public Panel deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonElement prop;
        Panel p = new Panel();
        JsonObject obj = jsonElement.getAsJsonObject();
        if (obj.has("id")) {
            prop = obj.get("id");
            p.setId(Integer.valueOf(prop.getAsJsonPrimitive().getAsInt()));
        }
        if (obj.has("title")) {
            prop = obj.get("title");
            p.setTitle(prop.getAsJsonPrimitive().getAsString());
        }
        if (obj.has("type")) {
            prop = obj.get("type");
            p.setType(prop.getAsJsonPrimitive().getAsString());
        }
        if (obj.has("datasource")) {
            prop = obj.get("datasource");
            if (prop.isJsonPrimitive()) {
                p.setDatasource(prop.getAsJsonPrimitive().getAsString());
            } else if (prop.isJsonObject()) {
                p.setDatasource(prop.getAsJsonObject().get("uid").getAsJsonPrimitive().getAsString());
            } else if (!p.getType().equals("row") || !prop.isJsonNull()) {
                throw new JsonParseException("JSON element 'datasource' was expected to be either a uid string, or an object containing a uid string and optional type string, but instead was: " + jsonElement);
            }
        }
        if (obj.has("description")) {
            prop = obj.get("description");
            p.setDescription(prop.getAsJsonPrimitive().getAsString());
        }
        if (obj.has("panels")) {
            ArrayList<Panel> panels = new ArrayList<Panel>();
            JsonArray arr = obj.get("panels").getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                panels.add((Panel)this.getGson().fromJson(arr.get(i), Panel.class));
            }
            p.setPanels(panels);
        }
        return p;
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter(Panel.class, (Object)this).create();
        }
        return this.gson;
    }
}

