/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.network;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IpListFromUrl {
    private static final Logger LOG = LoggerFactory.getLogger(IpListFromUrl.class);
    private static final String COMMENT_STR = " #";
    private static final char COMMENT_CHAR = '#';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> fetch(String url) {
        ArrayList<String> iplist;
        block10: {
            iplist = new ArrayList<String>();
            URL u = null;
            InputStream stream = null;
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                u = new URL(url);
                stream = u.openStream();
                if (stream != null) {
                    isr = new InputStreamReader(stream, StandardCharsets.UTF_8);
                    br = new BufferedReader(isr);
                    String ipLine = null;
                    String specIP = null;
                    while ((ipLine = br.readLine()) != null) {
                        if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                        int comIndex = ipLine.indexOf(COMMENT_STR);
                        if (comIndex == -1) {
                            specIP = ipLine;
                        } else {
                            specIP = ipLine.substring(0, comIndex);
                            ipLine = ipLine.trim();
                        }
                        iplist.add(specIP);
                    }
                } else {
                    LOG.warn("URL does not exist: {}", (Object)url);
                }
                IpListFromUrl.closeQuietly(br);
            }
            catch (IOException e) {
                LOG.error("Error reading URL: {}: {}", (Object)url, (Object)e.getLocalizedMessage());
                break block10;
            }
            finally {
                IpListFromUrl.closeQuietly(br);
                IpListFromUrl.closeQuietly(isr);
                IpListFromUrl.closeQuietly(stream);
            }
            IpListFromUrl.closeQuietly(isr);
            IpListFromUrl.closeQuietly(stream);
        }
        return iplist;
    }

    private static void closeQuietly(Closeable obj) {
        if (obj == null) {
            return;
        }
        try {
            obj.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to close {}", (Object)obj, (Object)e);
        }
    }
}

