/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.network;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opennms.core.network.IPAddress;

public class IPAddressRange
implements Comparable<IPAddressRange>,
Iterable<IPAddress> {
    private final IPAddress m_begin;
    private final IPAddress m_end;

    public IPAddressRange(String singleton) {
        this(singleton, singleton);
    }

    public IPAddressRange(IPAddress singleton) {
        this(singleton, singleton);
    }

    public IPAddressRange(String begin, String end) {
        this(new IPAddress(begin), new IPAddress(end));
    }

    public IPAddressRange(IPAddress begin, IPAddress end) {
        if (begin.isGreaterThan(end)) {
            throw new IllegalArgumentException(String.format("beginning of range (%s) must come before end of range (%s)", begin, end));
        }
        this.m_begin = begin;
        this.m_end = end;
    }

    public IPAddress getBegin() {
        return this.m_begin;
    }

    public IPAddress getEnd() {
        return this.m_end;
    }

    public BigInteger size() {
        BigInteger size = this.m_end.toBigInteger();
        size = size.subtract(this.m_begin.toBigInteger());
        size = size.add(BigInteger.ONE);
        return size;
    }

    public boolean contains(IPAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("addr should not be null");
        }
        return addr.isGreaterThanOrEqualTo(this.m_begin) && addr.isLessThanOrEqualTo(this.m_end);
    }

    public boolean contains(String addr) {
        return this.contains(new IPAddress(addr));
    }

    public boolean contains(IPAddressRange range) {
        return this.contains(range.getBegin()) && this.contains(range.getEnd());
    }

    public boolean overlaps(IPAddressRange range) {
        return this.contains(range.getBegin()) || this.contains(range.getEnd()) || range.contains(this.getBegin()) || range.contains(this.getEnd());
    }

    public boolean comesBefore(IPAddress addr) {
        return this.m_end.isLessThan(addr);
    }

    public boolean comesBefore(IPAddressRange range) {
        return this.comesBefore(range.getBegin());
    }

    public boolean comesAfter(IPAddress addr) {
        return this.m_begin.isGreaterThan(addr);
    }

    public boolean comesAfter(IPAddressRange range) {
        return this.comesAfter(range.getEnd());
    }

    public boolean adjoins(IPAddressRange range) {
        return this.comesImmediatelyBefore(range) || this.comesImmediatelyAfter(range);
    }

    private boolean comesImmediatelyAfter(IPAddressRange range) {
        return this.comesAfter(range) && this.getBegin().isSuccessorOf(range.getEnd());
    }

    private boolean comesImmediatelyBefore(IPAddressRange range) {
        return this.comesBefore(range) && this.getEnd().isPredecessorOf(range.getBegin());
    }

    @Override
    public Iterator<IPAddress> iterator() {
        return new IPAddressRangeIterator(this);
    }

    @Override
    public int compareTo(IPAddressRange r) {
        if (this.comesBefore(r)) {
            return -1;
        }
        if (this.comesAfter(r)) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPAddressRange) {
            IPAddressRange other = (IPAddressRange)obj;
            return this.m_begin.equals(other.m_begin) && this.m_end.equals(other.m_end);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.m_begin.hashCode() + this.m_end.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.m_begin).append(',').append(this.m_end).append(']');
        return buf.toString();
    }

    public boolean isSingleton() {
        return this.getBegin().equals(this.getEnd());
    }

    public boolean combinable(IPAddressRange range) {
        return this.overlaps(range) || this.adjoins(range);
    }

    public IPAddressRange combine(IPAddressRange range) {
        if (!this.combinable(range)) {
            throw new IllegalArgumentException(String.format("Range %s is not combinable with range %s", this, range));
        }
        return new IPAddressRange(IPAddress.min(range.getBegin(), this.getBegin()), IPAddress.max(this.getEnd(), range.getEnd()));
    }

    public IPAddressRange[] remove(IPAddressRange range) {
        if (range.contains(this)) {
            return new IPAddressRange[0];
        }
        if (!this.overlaps(range)) {
            return new IPAddressRange[]{this};
        }
        ArrayList<IPAddressRange> ranges = new ArrayList<IPAddressRange>(2);
        if (this.getBegin().isLessThan(range.getBegin())) {
            ranges.add(new IPAddressRange(this.getBegin(), range.getBegin().decr()));
        }
        if (range.getEnd().isLessThan(this.getEnd())) {
            ranges.add(new IPAddressRange(range.getEnd().incr(), this.getEnd()));
        }
        return ranges.toArray(new IPAddressRange[ranges.size()]);
    }

    private static class IPAddressRangeIterator
    implements Iterator<IPAddress> {
        private final IPAddressRange m_range;
        private IPAddress m_next;

        public IPAddressRangeIterator(IPAddressRange range) {
            this.m_range = range;
            this.m_next = range.getBegin();
        }

        @Override
        public boolean hasNext() {
            return this.m_next != null;
        }

        @Override
        public IPAddress next() {
            if (this.m_next == null) {
                throw new NoSuchElementException("Already returned the last element");
            }
            IPAddress next = this.m_next;
            this.m_next = next.incr();
            if (!this.m_range.contains(this.m_next)) {
                this.m_next = null;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("IPAddressRangeIterator.remove() is not yet implemented");
        }
    }
}

