/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client.template;

import java.io.IOException;
import java.util.Objects;
import org.opennms.features.jest.client.template.IndexSettings;
import org.opennms.features.jest.client.template.TemplateLoader;
import org.opennms.features.jest.client.template.TemplateMerger;
import org.opennms.features.jest.client.template.Version;

public class MergingTemplateLoader
implements TemplateLoader {
    private final TemplateLoader delegate;
    private final IndexSettings indexSettings;

    public MergingTemplateLoader(TemplateLoader delegate, IndexSettings indexSettings) {
        this.delegate = Objects.requireNonNull(delegate);
        this.indexSettings = indexSettings;
    }

    @Override
    public String load(Version serverVersion, String resource) throws IOException {
        String template = this.delegate.load(serverVersion, resource);
        return this.merge(template);
    }

    private String merge(String template) {
        String mergedTemplate = new TemplateMerger().merge(template, this.indexSettings);
        return mergedTemplate;
    }
}

