/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client.executors;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import java.io.IOException;
import java.util.HashMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.features.jest.client.ConnectionPoolShutdownException;
import org.opennms.features.jest.client.executors.RequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitedRetriesRequestExecutor
implements RequestExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(LimitedRetriesRequestExecutor.class);
    private int timeout;
    private int retryCount;

    public LimitedRetriesRequestExecutor(int timeout, int retryCount) {
        this.timeout = timeout;
        this.retryCount = retryCount;
    }

    @Override
    public <T extends JestResult> T execute(JestClient client, Action<T> clientRequest) throws IOException {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("strict-timeout", Boolean.TRUE);
        TimeoutTracker timeoutTracker = new TimeoutTracker(params, this.retryCount, this.timeout);
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry()) {
            timeoutTracker.startAttempt();
            try {
                JestResult result = client.execute(clientRequest);
                return (T)result;
            }
            catch (Exception exception) {
                if (exception instanceof IllegalStateException && exception.getMessage().equals("Connection pool shut down")) {
                    LOG.error("Connection pool shut down. Nothing we can do. Bailing");
                    throw new ConnectionPoolShutdownException(exception.getMessage(), exception);
                }
                if (timeoutTracker.getAttempt() + 1 > this.retryCount) {
                    throw new IOException("Could not perform request. Tried " + (timeoutTracker.getAttempt() + 1) + " times and gave up", exception);
                }
                LOG.warn("Exception while trying to execute REST operation (attempt {}/{}). Retrying.", new Object[]{timeoutTracker.getAttempt() + 1, this.retryCount + 1, exception});
                timeoutTracker.nextAttempt();
            }
        }
        throw new IllegalStateException("The request never produced a valid result. This should not have happened. Bailing.");
    }
}

