/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.vavr.CheckedFunction0;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JestClientWithCircuitBreaker
implements JestClient,
ApplicationContextAware,
InitializingBean {
    public static final String CIRCUIT_BREAKER_STATE_CHANGE_EVENT_UEI = "uei.opennms.org/circuitBreaker/stateChange";
    private static final Logger LOG = LoggerFactory.getLogger(JestClientWithCircuitBreaker.class);
    private final JestClient client;
    private final CircuitBreaker circuitBreaker;
    private EventForwarder eventForwarder = null;
    private ApplicationContext context;

    public void afterPropertiesSet() throws Exception {
        try {
            this.setEventForwarder((EventForwarder)this.context.getBean(EventForwarder.class));
        }
        catch (BeansException e) {
            LOG.error("Cannot get an EventForwarder in JestClientWithCircuitBreaker", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public JestClientWithCircuitBreaker(JestClient client, CircuitBreaker circuitBreaker) {
        this.client = Objects.requireNonNull(client);
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.circuitBreaker.getEventPublisher().onStateTransition(e -> {
            String from = e.getStateTransition().getFromState().toString();
            String to = e.getStateTransition().getToState().toString();
            LOG.info("CircuitBreaker with name {} changed state from {} to {}", new Object[]{this.circuitBreaker.getName(), from, to});
            if (this.eventForwarder != null) {
                Event event = new EventBuilder(CIRCUIT_BREAKER_STATE_CHANGE_EVENT_UEI, JestClientWithCircuitBreaker.class.getCanonicalName()).addParam("name", this.circuitBreaker.getName()).addParam("fromState", from).addParam("toState", to).getEvent();
                this.eventForwarder.sendNow(event);
            }
        });
    }

    public <T extends JestResult> T execute(Action<T> clientRequest) throws IOException {
        try {
            return (T)((JestResult)this.circuitBreaker.decorateCheckedSupplier((CheckedFunction0 & Serializable)() -> this.client.execute(clientRequest)).apply());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public <T extends JestResult> void executeAsync(Action<T> clientRequest, final JestResultHandler<? super T> jestResultHandler) {
        if (!this.circuitBreaker.tryAcquirePermission()) {
            jestResultHandler.failed((Exception)new CallNotPermittedException(this.circuitBreaker));
            return;
        }
        final long start = System.nanoTime();
        this.client.executeAsync(clientRequest, new JestResultHandler<T>(){

            public void completed(T result) {
                long durationInNanos = System.nanoTime() - start;
                JestClientWithCircuitBreaker.this.circuitBreaker.onSuccess(durationInNanos);
                jestResultHandler.completed(result);
            }

            public void failed(Exception ex) {
                long durationInNanos = System.nanoTime() - start;
                JestClientWithCircuitBreaker.this.circuitBreaker.onError(durationInNanos, (Throwable)ex);
                jestResultHandler.failed(ex);
            }
        });
    }

    @Deprecated
    public void shutdownClient() {
        this.circuitBreaker.getEventPublisher().onStateTransition(event -> {});
        this.client.shutdownClient();
    }

    public void setServers(Set<String> servers) {
        this.client.setServers(servers);
    }

    public void close() throws IOException {
        this.client.close();
    }
}

