/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import jcifs.CIFSContext;
import jcifs.util.Crypto;
import jcifs.util.Encdec;
import jcifs.util.Strings;

public final class NtlmUtil {
    static final byte[] S8 = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};

    private NtlmUtil() {
    }

    public static byte[] getNTLMv2Response(byte[] responseKeyNT, byte[] serverChallenge, byte[] clientChallenge, long nanos1601, byte[] avPairs) {
        int avPairsLength = avPairs != null ? avPairs.length : 0;
        byte[] temp = new byte[28 + avPairsLength + 4];
        Encdec.enc_uint32le(257, temp, 0);
        Encdec.enc_uint32le(0, temp, 4);
        Encdec.enc_uint64le(nanos1601, temp, 8);
        System.arraycopy(clientChallenge, 0, temp, 16, 8);
        Encdec.enc_uint32le(0, temp, 24);
        if (avPairs != null) {
            System.arraycopy(avPairs, 0, temp, 28, avPairsLength);
        }
        Encdec.enc_uint32le(0, temp, 28 + avPairsLength);
        return NtlmUtil.computeResponse(responseKeyNT, serverChallenge, temp, 0, temp.length);
    }

    public static byte[] getLMv2Response(byte[] responseKeyLM, byte[] serverChallenge, byte[] clientChallenge) {
        return NtlmUtil.computeResponse(responseKeyLM, serverChallenge, clientChallenge, 0, clientChallenge.length);
    }

    static byte[] computeResponse(byte[] responseKey, byte[] serverChallenge, byte[] clientData, int offset, int length) {
        MessageDigest hmac = Crypto.getHMACT64(responseKey);
        hmac.update(serverChallenge);
        hmac.update(clientData, offset, length);
        byte[] mac = hmac.digest();
        byte[] ret = new byte[mac.length + clientData.length];
        System.arraycopy(mac, 0, ret, 0, mac.length);
        System.arraycopy(clientData, 0, ret, mac.length, clientData.length);
        return ret;
    }

    public static byte[] nTOWFv2(String domain, String username, String password) {
        return NtlmUtil.nTOWFv2(domain, username, NtlmUtil.getNTHash(password));
    }

    public static byte[] nTOWFv2(String domain, String username, byte[] passwordHash) {
        MessageDigest hmac = Crypto.getHMACT64(passwordHash);
        hmac.update(Strings.getUNIBytes(username.toUpperCase()));
        hmac.update(Strings.getUNIBytes(domain));
        return hmac.digest();
    }

    public static byte[] getNTHash(String password) {
        if (password == null) {
            throw new NullPointerException("Password parameter is required");
        }
        MessageDigest md4 = Crypto.getMD4();
        md4.update(Strings.getUNIBytes(password));
        return md4.digest();
    }

    public static byte[] nTOWFv1(String password) {
        return NtlmUtil.getNTHash(password);
    }

    public static byte[] getNTLM2Response(byte[] passwordHash, byte[] serverChallenge, byte[] clientChallenge) throws GeneralSecurityException {
        byte[] sessionHash = new byte[8];
        MessageDigest md5 = Crypto.getMD5();
        md5.update(serverChallenge);
        md5.update(clientChallenge, 0, 8);
        System.arraycopy(md5.digest(), 0, sessionHash, 0, 8);
        byte[] key = new byte[21];
        System.arraycopy(passwordHash, 0, key, 0, 16);
        byte[] ntResponse = new byte[24];
        NtlmUtil.E(key, sessionHash, ntResponse);
        return ntResponse;
    }

    public static byte[] getLMv2Response(String domain, String user, String password, byte[] challenge, byte[] clientChallenge) throws GeneralSecurityException {
        return NtlmUtil.getLMv2Response(domain, user, NtlmUtil.getNTHash(password), challenge, clientChallenge);
    }

    public static byte[] getLMv2Response(String domain, String user, byte[] passwordHash, byte[] challenge, byte[] clientChallenge) throws GeneralSecurityException {
        byte[] response = new byte[24];
        MessageDigest hmac = Crypto.getHMACT64(passwordHash);
        hmac.update(Strings.getUNIBytes(user.toUpperCase()));
        hmac.update(Strings.getUNIBytes(domain.toUpperCase()));
        hmac = Crypto.getHMACT64(hmac.digest());
        hmac.update(challenge);
        hmac.update(clientChallenge);
        hmac.digest(response, 0, 16);
        System.arraycopy(clientChallenge, 0, response, 16, 8);
        return response;
    }

    public static byte[] getNTLMResponse(String password, byte[] challenge) throws GeneralSecurityException {
        return NtlmUtil.getNTLMResponse(NtlmUtil.getNTHash(password), challenge);
    }

    public static byte[] getNTLMResponse(byte[] passwordHash, byte[] challenge) throws GeneralSecurityException {
        byte[] p21 = new byte[21];
        byte[] p24 = new byte[24];
        System.arraycopy(passwordHash, 0, p21, 0, 16);
        NtlmUtil.E(p21, challenge, p24);
        return p24;
    }

    public static byte[] getPreNTLMResponse(CIFSContext tc, String password, byte[] challenge) throws GeneralSecurityException {
        byte[] p14 = new byte[14];
        byte[] p21 = new byte[21];
        byte[] p24 = new byte[24];
        byte[] passwordBytes = Strings.getOEMBytes(password, tc.getConfig());
        int passwordLength = passwordBytes.length;
        if (passwordLength > 14) {
            passwordLength = 14;
        }
        System.arraycopy(passwordBytes, 0, p14, 0, passwordLength);
        NtlmUtil.E(p14, S8, p21);
        NtlmUtil.E(p21, challenge, p24);
        return p24;
    }

    static void E(byte[] key, byte[] data, byte[] e) throws ShortBufferException {
        byte[] key7 = new byte[7];
        byte[] e8 = new byte[8];
        for (int i = 0; i < key.length / 7; ++i) {
            System.arraycopy(key, i * 7, key7, 0, 7);
            Cipher des = Crypto.getDES(key7);
            des.update(data, 0, data.length, e8);
            System.arraycopy(e8, 0, e, i * 8, 8);
        }
    }
}

